/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming;

import java.io.InputStream;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.internal.Logging;
import org.apache.spark.streaming.Checkpoint;
import org.apache.spark.streaming.Checkpoint$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;

public final class CheckpointReader$
implements Logging {
    public static CheckpointReader$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new CheckpointReader$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Option<Checkpoint> read(String checkpointDir) {
        return this.read(checkpointDir, new SparkConf(), SparkHadoopUtil$.MODULE$.get().conf(), true);
    }

    public Option<Checkpoint> read(String checkpointDir, SparkConf conf, Configuration hadoopConf, boolean ignoreReadError) {
        Option option;
        Object object = new Object();
        try {
            Path checkpointPath = new Path(checkpointDir);
            FileSystem fs = checkpointPath.getFileSystem(hadoopConf);
            Seq checkpointFiles = (Seq)Checkpoint$.MODULE$.getCheckpointFiles(checkpointDir, (Option<FileSystem>)new Some((Object)fs)).reverse();
            if (checkpointFiles.isEmpty()) {
                return None$.MODULE$;
            }
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Checkpoint files found: ").append(checkpointFiles.mkString(",")).toString());
            ObjectRef readError = ObjectRef.create(null);
            checkpointFiles.foreach((Function1 & Serializable & scala.Serializable)file -> {
                CheckpointReader$.$anonfun$read$2(fs, conf, object, readError, file);
                return BoxedUnit.UNIT;
            });
            if (!ignoreReadError) {
                throw new SparkException(new StringBuilder(41).append("Failed to read checkpoint from directory ").append(checkpointPath).toString(), (Throwable)((Exception)readError.elem));
            }
            option = None$.MODULE$;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                option = (Option)ex.value();
            }
            throw ex;
        }
        return option;
    }

    public boolean read$default$4() {
        return false;
    }

    public static final /* synthetic */ void $anonfun$read$2(FileSystem fs$1, SparkConf conf$1, Object nonLocalReturnKey1$1, ObjectRef readError$1, Path file) {
        MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Attempting to load checkpoint from file ").append(file).toString());
        try {
            FSDataInputStream fis = fs$1.open(file);
            Checkpoint cp = Checkpoint$.MODULE$.deserialize((InputStream)fis, conf$1);
            MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Checkpoint successfully loaded from file ").append(file).toString());
            MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Checkpoint was generated at time ").append(cp.checkpointTime()).toString());
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)cp));
        }
        catch (Exception e) {
            readError$1.elem = e;
            MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Error reading checkpoint from file ").append(file).toString(), e);
            return;
        }
    }

    private CheckpointReader$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

