/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.internal.Logging;
import org.apache.spark.io.CompressionCodec;
import org.apache.spark.io.CompressionCodec$;
import org.apache.spark.streaming.Checkpoint;
import org.apache.spark.streaming.ObjectInputStreamWithLoader;
import org.apache.spark.streaming.Time;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.matching.Regex;

public final class Checkpoint$
implements Logging,
scala.Serializable {
    public static Checkpoint$ MODULE$;
    private final String PREFIX;
    private final Regex REGEX;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new Checkpoint$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String PREFIX() {
        return this.PREFIX;
    }

    public Regex REGEX() {
        return this.REGEX;
    }

    public Path checkpointFile(String checkpointDir, Time checkpointTime) {
        return new Path(checkpointDir, new StringBuilder(0).append(this.PREFIX()).append(checkpointTime.milliseconds()).toString());
    }

    public Path checkpointBackupFile(String checkpointDir, Time checkpointTime) {
        return new Path(checkpointDir, new StringBuilder(3).append(this.PREFIX()).append(checkpointTime.milliseconds()).append(".bk").toString());
    }

    public Seq<Path> getCheckpointFiles(String checkpointDir, Option<FileSystem> fsOption) {
        Seq seq;
        block3: {
            Path path = new Path(checkpointDir);
            FileSystem fs = (FileSystem)fsOption.getOrElse((Function0 & Serializable & scala.Serializable)() -> path.getFileSystem(SparkHadoopUtil$.MODULE$.get().conf()));
            try {
                FileStatus[] statuses = fs.listStatus(path);
                if (statuses != null) {
                    Path[] paths = (Path[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])statuses)).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getPath(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class)));
                    Path[] filtered = (Path[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])paths)).filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)Checkpoint$.$anonfun$getCheckpointFiles$3(p)));
                    seq = Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filtered)).sortWith((Function2 & Serializable & scala.Serializable)(path1, path2) -> BoxesRunTime.boxToBoolean((boolean)this.sortFunc$1(path1, path2))));
                    break block3;
                }
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Listing ").append(path).append(" returned null").toString());
                seq = (Seq)Seq$.MODULE$.empty();
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Checkpoint directory ").append(path).append(" does not exist").toString());
                seq = (Seq)Seq$.MODULE$.empty();
            }
        }
        return seq;
    }

    public Option<FileSystem> getCheckpointFiles$default$2() {
        return None$.MODULE$;
    }

    public byte[] serialize(Checkpoint checkpoint, SparkConf conf) {
        CompressionCodec compressionCodec = CompressionCodec$.MODULE$.createCodec(conf);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        OutputStream zos = compressionCodec.compressedOutputStream((OutputStream)bos);
        ObjectOutputStream oos = new ObjectOutputStream(zos);
        Utils$.MODULE$.tryWithSafeFinally((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> oos.writeObject(checkpoint), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> oos.close());
        return bos.toByteArray();
    }

    public Checkpoint deserialize(InputStream inputStream, SparkConf conf) {
        CompressionCodec compressionCodec = CompressionCodec$.MODULE$.createCodec(conf);
        ObjectRef ois = ObjectRef.create(null);
        return (Checkpoint)Utils$.MODULE$.tryWithSafeFinally((Function0 & Serializable & scala.Serializable)() -> {
            InputStream zis = compressionCodec.compressedInputStream(inputStream);
            ois$1.elem = new ObjectInputStreamWithLoader(zis, Thread.currentThread().getContextClassLoader());
            Checkpoint cp = (Checkpoint)((ObjectInputStreamWithLoader)ois$1.elem).readObject();
            cp.validate();
            return cp;
        }, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                if ((ObjectInputStreamWithLoader)ois$1.elem == null) break block0;
                ((ObjectInputStreamWithLoader)ois$1.elem).close();
            }
        });
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final boolean sortFunc$1(Path path1, Path path2) {
        String string = path1.getName();
        Option option = this.REGEX().unapplySeq((CharSequence)string);
        if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(2) != 0) {
            throw new MatchError((Object)string);
        }
        String x = (String)((LinearSeqOptimized)option.get()).apply(0);
        String y = (String)((LinearSeqOptimized)option.get()).apply(1);
        Tuple2.mcJZ.sp sp2 = new Tuple2.mcJZ.sp(new StringOps(Predef$.MODULE$.augmentString(x)).toLong(), !y.isEmpty());
        Tuple2.mcJZ.sp sp3 = sp2;
        if (sp3 == null) {
            throw new MatchError((Object)sp3);
        }
        long time1 = sp3._1$mcJ$sp();
        boolean bk1 = sp3._2$mcZ$sp();
        Tuple2.mcJZ.sp sp4 = new Tuple2.mcJZ.sp(time1, bk1);
        Tuple2.mcJZ.sp sp5 = sp4;
        long time12 = sp5._1$mcJ$sp();
        boolean bk12 = sp5._2$mcZ$sp();
        String string2 = path2.getName();
        Option option2 = this.REGEX().unapplySeq((CharSequence)string2);
        if (option2.isEmpty() || option2.get() == null || ((LinearSeqOptimized)option2.get()).lengthCompare(2) != 0) {
            throw new MatchError((Object)string2);
        }
        String x2 = (String)((LinearSeqOptimized)option2.get()).apply(0);
        String y2 = (String)((LinearSeqOptimized)option2.get()).apply(1);
        Tuple2.mcJZ.sp sp6 = new Tuple2.mcJZ.sp(new StringOps(Predef$.MODULE$.augmentString(x2)).toLong(), !y2.isEmpty());
        Tuple2.mcJZ.sp sp7 = sp6;
        if (sp7 == null) {
            throw new MatchError((Object)sp7);
        }
        long time2 = sp7._1$mcJ$sp();
        boolean bk2 = sp7._2$mcZ$sp();
        Tuple2.mcJZ.sp sp8 = new Tuple2.mcJZ.sp(time2, bk2);
        Tuple2.mcJZ.sp sp9 = sp8;
        long time22 = sp9._1$mcJ$sp();
        boolean bk22 = sp9._2$mcZ$sp();
        return time12 < time22 || time12 == time22 && bk12;
    }

    public static final /* synthetic */ boolean $anonfun$getCheckpointFiles$3(Path p) {
        return MODULE$.REGEX().findFirstIn((CharSequence)p.toString()).nonEmpty();
    }

    private Checkpoint$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.PREFIX = "checkpoint-";
        this.REGEX = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(16).append(this.PREFIX()).append("([\\d]+)([\\w\\.]*)").toString())).r();
    }
}

