/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.util.Locale;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions$;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class PostgresDialect$
extends JdbcDialect {
    public static PostgresDialect$ MODULE$;

    static {
        new PostgresDialect$();
    }

    @Override
    public boolean canHandle(String url) {
        return url.toLowerCase(Locale.ROOT).startsWith("jdbc:postgresql");
    }

    @Override
    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        Some some;
        if (sqlType == 7) {
            some = new Some((Object)FloatType$.MODULE$);
        } else if (sqlType == 5) {
            some = new Some((Object)ShortType$.MODULE$);
        } else if (sqlType == -7 && typeName.equals("bit") && size != 1) {
            some = new Some((Object)BinaryType$.MODULE$);
        } else if (sqlType == 1111) {
            some = new Some((Object)StringType$.MODULE$);
        } else if (sqlType == 2003) {
            int scale = (int)md.build().getLong("scale");
            some = this.toCatalystType((String)new StringOps(Predef$.MODULE$.augmentString(typeName)).drop(1), size, scale).map((Function1 & Serializable & scala.Serializable)x$1 -> ArrayType$.MODULE$.apply(x$1));
        } else {
            some = None$.MODULE$;
        }
        return some;
    }

    private Option<DataType> toCatalystType(String typeName, int precision, int scale) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        boolean bl6;
        String string = typeName;
        Object object = "bool".equals(string) ? new Some((Object)BooleanType$.MODULE$) : ("bit".equals(string) ? new Some((Object)BinaryType$.MODULE$) : ("int2".equals(string) ? new Some((Object)ShortType$.MODULE$) : ("int4".equals(string) ? new Some((Object)IntegerType$.MODULE$) : ((bl6 = "int8".equals(string) ? true : "oid".equals(string)) ? new Some((Object)LongType$.MODULE$) : ("float4".equals(string) ? new Some((Object)FloatType$.MODULE$) : ((bl5 = "money".equals(string) ? true : "float8".equals(string)) ? new Some((Object)DoubleType$.MODULE$) : ((bl4 = "text".equals(string) ? true : ("varchar".equals(string) ? true : ("char".equals(string) ? true : ("cidr".equals(string) ? true : ("inet".equals(string) ? true : ("json".equals(string) ? true : ("jsonb".equals(string) ? true : "uuid".equals(string)))))))) ? new Some((Object)StringType$.MODULE$) : ("bytea".equals(string) ? new Some((Object)BinaryType$.MODULE$) : ((bl3 = "timestamp".equals(string) ? true : ("timestamptz".equals(string) ? true : ("time".equals(string) ? true : "timetz".equals(string)))) ? new Some((Object)TimestampType$.MODULE$) : ("date".equals(string) ? new Some((Object)DateType$.MODULE$) : ((bl2 = "numeric".equals(string) ? true : "decimal".equals(string)) && precision > 0 ? new Some((Object)DecimalType$.MODULE$.bounded(precision, scale)) : ((bl = "numeric".equals(string) ? true : "decimal".equals(string)) ? new Some((Object)DecimalType$.MODULE$.SYSTEM_DEFAULT()) : None$.MODULE$))))))))))));
        return object;
    }

    @Override
    public Option<JdbcType> getJDBCType(DataType dt) {
        Object object;
        DataType dataType = dt;
        if (StringType$.MODULE$.equals(dataType)) {
            object = new Some((Object)new JdbcType("TEXT", 1));
        } else if (BinaryType$.MODULE$.equals(dataType)) {
            object = new Some((Object)new JdbcType("BYTEA", -2));
        } else if (BooleanType$.MODULE$.equals(dataType)) {
            object = new Some((Object)new JdbcType("BOOLEAN", 16));
        } else if (FloatType$.MODULE$.equals(dataType)) {
            object = new Some((Object)new JdbcType("FLOAT4", 6));
        } else if (DoubleType$.MODULE$.equals(dataType)) {
            object = new Some((Object)new JdbcType("FLOAT8", 8));
        } else {
            boolean bl = ShortType$.MODULE$.equals(dataType) ? true : ByteType$.MODULE$.equals(dataType);
            if (bl) {
                object = new Some((Object)new JdbcType("SMALLINT", 5));
            } else if (dataType instanceof DecimalType) {
                DecimalType decimalType = (DecimalType)dataType;
                object = new Some((Object)new JdbcType(new StringBuilder(10).append("NUMERIC(").append(decimalType.precision()).append(",").append(decimalType.scale()).append(")").toString(), 2));
            } else {
                ArrayType arrayType;
                DataType et;
                object = dataType instanceof ArrayType && (et = (arrayType = (ArrayType)dataType).elementType()) instanceof AtomicType ? this.getJDBCType(et).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.databaseTypeDefinition()).orElse((Function0 & Serializable & scala.Serializable)() -> JdbcUtils$.MODULE$.getCommonJDBCType(et).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.databaseTypeDefinition())).map((Function1 & Serializable & scala.Serializable)typeName -> new JdbcType(new StringBuilder(2).append((String)typeName).append("[]").toString(), 2003)) : None$.MODULE$;
            }
        }
        return object;
    }

    @Override
    public String getTableExistsQuery(String table) {
        return new StringBuilder(22).append("SELECT 1 FROM ").append(table).append(" LIMIT 1").toString();
    }

    @Override
    public Option<Object> isCascadingTruncateTable() {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    @Override
    public String getTruncateQuery(String table, Option<Object> cascade) {
        Some some;
        boolean bl;
        Option<Object> option = cascade;
        String string = option instanceof Some && (bl = BoxesRunTime.unboxToBoolean((Object)(some = (Some)option).value())) ? new StringBuilder(28).append("TRUNCATE TABLE ONLY ").append(table).append(" CASCADE").toString() : new StringBuilder(20).append("TRUNCATE TABLE ONLY ").append(table).toString();
        return string;
    }

    @Override
    public Option<Object> getTruncateQuery$default$2() {
        return this.isCascadingTruncateTable();
    }

    @Override
    public void beforeFetch(Connection connection, Map<String, String> properties) {
        block0: {
            super.beforeFetch(connection, properties);
            if (new StringOps(Predef$.MODULE$.augmentString((String)properties.getOrElse((Object)JDBCOptions$.MODULE$.JDBC_BATCH_FETCH_SIZE(), (Function0 & Serializable & scala.Serializable)() -> "0"))).toInt() <= 0) break block0;
            connection.setAutoCommit(false);
        }
    }

    private Object readResolve() {
        return MODULE$;
    }

    private PostgresDialect$() {
        MODULE$ = this;
    }
}

