/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ConcurrentModificationException;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager$;
import org.apache.spark.sql.execution.streaming.HDFSMetadataLog$;
import org.apache.spark.sql.execution.streaming.MetadataLog;
import org.json4s.Formats;
import org.json4s.NoTypeHints$;
import org.json4s.TypeHints;
import org.json4s.jackson.Serialization$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t5b\u0001B\u0011#\u0001=B\u0001\"\u0013\u0001\u0003\u0002\u0003\u0006IA\u0013\u0005\t\u001d\u0002\u0011\t\u0011)A\u0005\u001f\"A!\f\u0001B\u0002B\u0003-1\fC\u0003b\u0001\u0011\u0005!\rC\u0004i\u0001\t\u0007I1B5\t\u000f\u0005\u0015\u0001\u0001)A\u0005U\"I\u0011q\u0001\u0001C\u0002\u0013-\u0011\u0011\u0002\u0005\t\u0003#\u0001\u0001\u0015!\u0003\u0002\f!I\u00111\u0003\u0001C\u0002\u0013\u0005\u0011Q\u0003\u0005\t\u0003O\u0001\u0001\u0015!\u0003\u0002\u0018!I\u0011\u0011\u0006\u0001C\u0002\u0013E\u00111\u0006\u0005\t\u0003g\u0001\u0001\u0015!\u0003\u0002.!I\u0011Q\u0007\u0001C\u0002\u0013E\u0011q\u0007\u0005\t\u0003{\u0001\u0001\u0015!\u0003\u0002:!9\u0011Q\u000b\u0001\u0005\u0012\u0005]\u0003bBA2\u0001\u0011E\u0011Q\r\u0005\b\u0003S\u0002A\u0011CA6\u0011\u001d\t)\b\u0001C\t\u0003oBq!a%\u0001\t#\t)\nC\u0004\u0002\"\u0002!\t%a)\t\u000f\u0005%\u0006\u0001\"\u0003\u0002,\"9\u0011\u0011\u0017\u0001\u0005B\u0005M\u0006bBAY\u0001\u0011\u0005\u0013Q\u0018\u0005\b\u0003+\u0004A\u0011IAl\u0011\u001d\tY\u000e\u0001C\u0001\u0003;Dq!a:\u0001\t\u0003\nI\u000fC\u0004\u0002p\u0002!\t!!=\t\u0011\u0005U\b\u0001\"\u0001'\u0003o<qAa\u0002#\u0011\u0003\u0011IA\u0002\u0004\"E!\u0005!1\u0002\u0005\u0007Cz!\tA!\u0004\t\u000f\t=a\u0004\"\u0001\u0003\u0012\ty\u0001\n\u0012$T\u001b\u0016$\u0018\rZ1uC2{wM\u0003\u0002$I\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003K\u0019\n\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005\u001dB\u0013aA:rY*\u0011\u0011FK\u0001\u0006gB\f'o\u001b\u0006\u0003W1\na!\u00199bG\",'\"A\u0017\u0002\u0007=\u0014xm\u0001\u0001\u0016\u0005Aj4\u0003\u0002\u00012o\r\u0003\"AM\u001b\u000e\u0003MR\u0011\u0001N\u0001\u0006g\u000e\fG.Y\u0005\u0003mM\u0012a!\u00118z%\u00164\u0007c\u0001\u001d:w5\t!%\u0003\u0002;E\tYQ*\u001a;bI\u0006$\u0018\rT8h!\taT\b\u0004\u0001\u0005\u000by\u0002!\u0019A \u0003\u0003Q\u000b\"\u0001Q\u0019\u0011\u0005I\n\u0015B\u0001\"4\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"\u0001R$\u000e\u0003\u0015S!A\u0012\u0015\u0002\u0011%tG/\u001a:oC2L!\u0001S#\u0003\u000f1{wmZ5oO\u0006a1\u000f]1sWN+7o]5p]B\u00111\nT\u0007\u0002M%\u0011QJ\n\u0002\r'B\f'o[*fgNLwN\\\u0001\u0005a\u0006$\b\u000e\u0005\u0002Q/:\u0011\u0011+\u0016\t\u0003%Nj\u0011a\u0015\u0006\u0003):\na\u0001\u0010:p_Rt\u0014B\u0001,4\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001,\u0017\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Y\u001b\u0014AC3wS\u0012,gnY3%cA\u0019AlX\u001e\u000e\u0003uS!AX\u001a\u0002\u000fI,g\r\\3di&\u0011\u0001-\u0018\u0002\t\u00072\f7o\u001d+bO\u00061A(\u001b8jiz\"2a\u00194h)\t!W\rE\u00029\u0001mBQA\u0017\u0003A\u0004mCQ!\u0013\u0003A\u0002)CQA\u0014\u0003A\u0002=\u000bqAZ8s[\u0006$8/F\u0001k%\rY\u0017G\u001d\u0004\u0005Y\u0002\u0001!N\u0001\u0007=e\u00164\u0017N\\3nK:$h(\u0003\u0002i]&\u0011q\u000e\u001d\u0002\u000e'\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8\u000b\u0005Ed\u0013A\u00026t_:$4\u000f\u0005\u0002ti6\t\u0001/\u0003\u0002va\n9ai\u001c:nCR\u001c\bbB<l\u0005\u0004%\t\u0001_\u0001\u000bI\u0006$XMR8s[\u0006$X#A=\u0011\u0005MT\u0018BA>q\u0005)!\u0015\r^3G_Jl\u0017\r\u001e\u0005\b{.\u0014\r\u0011\"\u0001\u007f\u0003%!\u0018\u0010]3IS:$8/F\u0001\u0000!\r\u0019\u0018\u0011A\u0005\u0004\u0003\u0007\u0001(!\u0003+za\u0016D\u0015N\u001c;t\u0003!1wN]7biN\u0004\u0013\u0001C7b]&4Wm\u001d;\u0016\u0005\u0005-\u0001\u0003\u0002/\u0002\u000emJ1!a\u0004^\u0005!i\u0015M\\5gKN$\u0018!C7b]&4Wm\u001d;!\u00031iW\r^1eCR\f\u0007+\u0019;i+\t\t9\u0002\u0005\u0003\u0002\u001a\u0005\rRBAA\u000e\u0015\u0011\ti\"a\b\u0002\u0005\u0019\u001c(bAA\u0011U\u00051\u0001.\u00193p_BLA!!\n\u0002\u001c\t!\u0001+\u0019;i\u00035iW\r^1eCR\f\u0007+\u0019;iA\u0005Ya-\u001b7f\u001b\u0006t\u0017mZ3s+\t\ti\u0003E\u00029\u0003_I1!!\r#\u0005U\u0019\u0005.Z2la>Lg\u000e\u001e$jY\u0016l\u0015M\\1hKJ\fABZ5mK6\u000bg.Y4fe\u0002\n\u0001CY1uG\"4\u0015\u000e\\3t\r&dG/\u001a:\u0016\u0005\u0005e\"CBA\u001e\u0003\u007f\tyEB\u0003m\u001d\u0001\tI$A\tcCR\u001c\u0007NR5mKN4\u0015\u000e\u001c;fe\u0002\u0002B!!\u0011\u0002L5\u0011\u00111\t\u0006\u0005\u0003\u000b\n9%\u0001\u0003mC:<'BAA%\u0003\u0011Q\u0017M^1\n\t\u00055\u00131\t\u0002\u0007\u001f\nTWm\u0019;\u0011\t\u0005e\u0011\u0011K\u0005\u0005\u0003'\nYB\u0001\u0006QCRDg)\u001b7uKJ\fQBY1uG\"LE\rV8QCRDG\u0003BA\f\u00033Bq!a\u0017\u0010\u0001\u0004\ti&A\u0004cCR\u001c\u0007.\u00133\u0011\u0007I\ny&C\u0002\u0002bM\u0012A\u0001T8oO\u0006i\u0001/\u0019;i)>\u0014\u0015\r^2i\u0013\u0012$B!!\u0018\u0002h!1a\n\u0005a\u0001\u0003/\t1\"[:CCR\u001c\u0007NR5mKR!\u0011QNA:!\r\u0011\u0014qN\u0005\u0004\u0003c\u001a$a\u0002\"p_2,\u0017M\u001c\u0005\u0007\u001dF\u0001\r!a\u0006\u0002\u0013M,'/[1mSj,GCBA=\u0003\u007f\n\u0019\tE\u00023\u0003wJ1!! 4\u0005\u0011)f.\u001b;\t\r\u0005\u0005%\u00031\u0001<\u0003!iW\r^1eCR\f\u0007bBAC%\u0001\u0007\u0011qQ\u0001\u0004_V$\b\u0003BAE\u0003\u001fk!!a#\u000b\t\u00055\u0015qI\u0001\u0003S>LA!!%\u0002\f\naq*\u001e;qkR\u001cFO]3b[\u0006YA-Z:fe&\fG.\u001b>f)\rY\u0014q\u0013\u0005\b\u00033\u001b\u0002\u0019AAN\u0003\tIg\u000e\u0005\u0003\u0002\n\u0006u\u0015\u0002BAP\u0003\u0017\u00131\"\u00138qkR\u001cFO]3b[\u0006\u0019\u0011\r\u001a3\u0015\r\u00055\u0014QUAT\u0011\u001d\tY\u0006\u0006a\u0001\u0003;Ba!!!\u0015\u0001\u0004Y\u0014\u0001E<sSR,')\u0019;dQR{g)\u001b7f)\u0019\tI(!,\u00020\"1\u0011\u0011Q\u000bA\u0002mBaAT\u000bA\u0002\u0005]\u0011aA4fiR!\u0011QWA^!\u0011\u0011\u0014qW\u001e\n\u0007\u0005e6G\u0001\u0004PaRLwN\u001c\u0005\b\u000372\u0002\u0019AA/)\u0019\ty,a3\u0002RB)!'!1\u0002F&\u0019\u00111Y\u001a\u0003\u000b\u0005\u0013(/Y=\u0011\rI\n9-!\u0018<\u0013\r\tIm\r\u0002\u0007)V\u0004H.\u001a\u001a\t\u000f\u00055w\u00031\u0001\u0002P\u000691\u000f^1si&#\u0007#\u0002\u001a\u00028\u0006u\u0003bBAj/\u0001\u0007\u0011qZ\u0001\u0006K:$\u0017\nZ\u0001\nO\u0016$H*\u0019;fgR$\"!!7\u0011\u000bI\n9,!2\u0002)\u001d,Go\u0014:eKJ,GMQ1uG\"4\u0015\u000e\\3t)\t\ty\u000eE\u00033\u0003\u0003\f\t\u000f\u0005\u0003\u0002\u001a\u0005\r\u0018\u0002BAs\u00037\u0011!BR5mKN#\u0018\r^;t\u0003\u0015\u0001XO]4f)\u0011\tI(a;\t\u000f\u00055(\u00041\u0001\u0002^\u0005\u0001B\u000f\u001b:fg\"|G\u000e\u001a\"bi\u000eD\u0017\nZ\u0001\u000baV\u0014x-Z!gi\u0016\u0014H\u0003BA=\u0003gDq!!<\u001c\u0001\u0004\ti&A\bwC2LG-\u0019;f-\u0016\u00148/[8o)\u0019\tI0a@\u0003\u0004A\u0019!'a?\n\u0007\u0005u8GA\u0002J]RDaA!\u0001\u001d\u0001\u0004y\u0015\u0001\u0002;fqRDqA!\u0002\u001d\u0001\u0004\tI0A\nnCb\u001cV\u000f\u001d9peR,GMV3sg&|g.A\bI\t\u001a\u001bV*\u001a;bI\u0006$\u0018\rT8h!\tAdd\u0005\u0002\u001fcQ\u0011!\u0011B\u0001\u000fm\u0016\u0014\u0018NZ=CCR\u001c\u0007.\u00133t)!\tIHa\u0005\u0003*\t-\u0002b\u0002B\u000bA\u0001\u0007!qC\u0001\tE\u0006$8\r[%egB1!\u0011\u0004B\u0012\u0003;rAAa\u0007\u0003 9\u0019!K!\b\n\u0003QJ1A!\t4\u0003\u001d\u0001\u0018mY6bO\u0016LAA!\n\u0003(\t\u00191+Z9\u000b\u0007\t\u00052\u0007C\u0004\u0002N\u0002\u0002\r!a4\t\u000f\u0005M\u0007\u00051\u0001\u0002P\u0002")
public class HDFSMetadataLog<T>
implements MetadataLog<T>,
Logging {
    private final Formats formats;
    private final Manifest<T> manifest;
    private final Path metadataPath;
    private final CheckpointFileManager fileManager;
    private final PathFilter batchFilesFilter;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static void verifyBatchIds(Seq<Object> seq, Option<Object> option, Option<Object> option2) {
        HDFSMetadataLog$.MODULE$.verifyBatchIds(seq, option, option2);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Formats formats() {
        return this.formats;
    }

    private Manifest<T> manifest() {
        return this.manifest;
    }

    public Path metadataPath() {
        return this.metadataPath;
    }

    public CheckpointFileManager fileManager() {
        return this.fileManager;
    }

    public PathFilter batchFilesFilter() {
        return this.batchFilesFilter;
    }

    public Path batchIdToPath(long batchId) {
        return new Path(this.metadataPath(), ((Object)BoxesRunTime.boxToLong((long)batchId)).toString());
    }

    public long pathToBatchId(Path path) {
        return new StringOps(Predef$.MODULE$.augmentString(path.getName())).toLong();
    }

    public boolean isBatchFile(Path path) {
        boolean bl;
        try {
            new StringOps(Predef$.MODULE$.augmentString(path.getName())).toLong();
            bl = true;
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        return bl;
    }

    public void serialize(T metadata, OutputStream out) {
        Serialization$.MODULE$.write(metadata, out, this.formats());
    }

    public T deserialize(InputStream in) {
        InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);
        return (T)Serialization$.MODULE$.read((Reader)reader, this.formats(), this.manifest());
    }

    @Override
    public boolean add(long batchId, T metadata) {
        Predef$.MODULE$.require(metadata != null, (Function0 & Serializable & scala.Serializable)() -> "'null' metadata cannot written to a metadata log");
        return BoxesRunTime.unboxToBoolean((Object)this.get(batchId).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)HDFSMetadataLog.$anonfun$add$2(x$1))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            this.writeBatchToFile(metadata, this.batchIdToPath(batchId));
            return true;
        }));
    }

    private void writeBatchToFile(T metadata, Path path) {
        CheckpointFileManager.CancellableFSDataOutputStream output = this.fileManager().createAtomic(path, false);
        try {
            this.serialize(metadata, (OutputStream)((Object)output));
            output.close();
        }
        catch (FileAlreadyExistsException e) {
            throw new ConcurrentModificationException(new StringBuilder(50).append("Multiple streaming queries are concurrently using ").append(path).toString(), e);
        }
        finally {
            output.cancel();
        }
    }

    @Override
    public Option<T> get(long batchId) {
        None$ none$;
        block6: {
            Path batchMetadataFile = this.batchIdToPath(batchId);
            if (this.fileManager().exists(batchMetadataFile)) {
                FSDataInputStream input = this.fileManager().open(batchMetadataFile);
                try {
                    try {
                        none$ = new Some(this.deserialize((InputStream)input));
                        break block6;
                    }
                    catch (IllegalStateException ise) {
                        throw new IllegalStateException(new StringBuilder(26).append("Failed to read log file ").append(batchMetadataFile).append(". ").append(ise.getMessage()).toString(), ise);
                    }
                }
                finally {
                    IOUtils.closeQuietly((InputStream)input);
                }
            }
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Unable to find batch ").append(batchMetadataFile).toString());
            none$ = None$.MODULE$;
        }
        return none$;
    }

    @Override
    public Tuple2<Object, T>[] get(Option<Object> startId, Option<Object> endId) {
        Predef$.MODULE$.assert(startId.isEmpty() || endId.isEmpty() || BoxesRunTime.unboxToLong((Object)startId.get()) <= BoxesRunTime.unboxToLong((Object)endId.get()));
        FileStatus[] files = this.fileManager().list(this.metadataPath(), this.batchFilesFilter());
        long[] batchIds = (long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).map((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToLong((long)this.pathToBatchId(f.getPath())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)batchId -> !(!endId.isEmpty() && batchId > BoxesRunTime.unboxToLong((Object)endId.get()) || !startId.isEmpty() && batchId < BoxesRunTime.unboxToLong((Object)startId.get()))))).sorted((Ordering)Ordering.Long$.MODULE$);
        HDFSMetadataLog$.MODULE$.verifyBatchIds((Seq<Object>)Predef$.MODULE$.wrapLongArray(batchIds), startId, endId);
        return (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(batchIds)).map((Function1 & Serializable & scala.Serializable)batchId -> HDFSMetadataLog.$anonfun$get$4(this, BoxesRunTime.unboxToLong((Object)batchId)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)HDFSMetadataLog.$anonfun$get$5(x$2))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            long batchId = tuple2._1$mcJ$sp();
            Option metadataOption = (Option)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)batchId), metadataOption.get());
            return tuple22;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
    }

    @Override
    public Option<Tuple2<Object, T>> getLatest() {
        Option option;
        Object object = new Object();
        try {
            long[] batchIds = (long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.fileManager().list(this.metadataPath(), this.batchFilesFilter()))).map((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToLong((long)this.pathToBatchId(f.getPath())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).sorted(Ordering.Long$.MODULE$.reverse());
            new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(batchIds)).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)batchId -> {
                Option batch = this.get(batchId);
                if (batch.isDefined()) {
                    throw new NonLocalReturnControl(object, (Object)new Some((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)batchId), batch.get())));
                }
            });
            option = None$.MODULE$;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                option = (Option)ex.value();
            }
            throw ex;
        }
        return option;
    }

    public FileStatus[] getOrderedBatchFiles() {
        return (FileStatus[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.fileManager().list(this.metadataPath(), this.batchFilesFilter()))).sortBy((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToLong((long)this.pathToBatchId(f.getPath())), (Ordering)Ordering.Long$.MODULE$))).reverse();
    }

    @Override
    public void purge(long thresholdBatchId) {
        long[] batchIds = (long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.fileManager().list(this.metadataPath(), this.batchFilesFilter()))).map((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToLong((long)this.pathToBatchId(f.getPath())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()));
        new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(batchIds)).withFilter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)batchId -> batchId < thresholdBatchId).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)batchId -> {
            Path path = this.batchIdToPath(batchId);
            this.fileManager().delete(path);
            this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Removed metadata log file: ").append(path).toString());
        });
    }

    public void purgeAfter(long thresholdBatchId) {
        long[] batchIds = (long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.fileManager().list(this.metadataPath(), this.batchFilesFilter()))).map((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToLong((long)this.pathToBatchId(f.getPath())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()));
        new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(batchIds)).withFilter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)batchId -> batchId > thresholdBatchId).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)batchId -> {
            Path path = this.batchIdToPath(batchId);
            this.fileManager().delete(path);
            this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Removed metadata log file: ").append(path).toString());
        });
    }

    public int validateVersion(String text, int maxSupportedVersion) {
        if (text.length() > 0 && StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(text), 0) == 'v') {
            int n;
            try {
                n = new StringOps(Predef$.MODULE$.augmentString(text.substring(1, text.length()))).toInt();
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalStateException(new StringBuilder(65).append("Log file was malformed: failed to read correct log ").append("version from ").append(text).append(".").toString());
            }
            int version = n;
            if (version > 0) {
                if (version > maxSupportedVersion) {
                    throw new IllegalStateException(new StringBuilder(183).append("UnsupportedLogVersion: maximum supported log version ").append("is v").append(maxSupportedVersion).append(", but encountered v").append(version).append(". The log file was produced ").append("by a newer version of Spark and cannot be read by this version. Please upgrade.").toString());
                }
                return version;
            }
        }
        throw new IllegalStateException(new StringBuilder(65).append("Log file was malformed: failed to read correct log ").append("version from ").append(text).append(".").toString());
    }

    public static final /* synthetic */ boolean $anonfun$add$2(Object x$1) {
        return false;
    }

    public static final /* synthetic */ Tuple2 $anonfun$get$4(HDFSMetadataLog $this, long batchId) {
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)batchId), $this.get(batchId));
    }

    public static final /* synthetic */ boolean $anonfun$get$5(Tuple2 x$2) {
        return ((Option)x$2._2()).isDefined();
    }

    public HDFSMetadataLog(SparkSession sparkSession, String path, ClassTag<T> evidence$1) {
        Logging.$init$((Logging)this);
        this.formats = Serialization$.MODULE$.formats((TypeHints)NoTypeHints$.MODULE$);
        this.manifest = Predef$.MODULE$.Manifest().classType(((ClassTag)Predef$.MODULE$.implicitly(evidence$1)).runtimeClass());
        Class clazz = ((ClassTag)Predef$.MODULE$.implicitly(this.manifest())).runtimeClass();
        Class<Seq> clazz2 = Seq.class;
        Predef$.MODULE$.require(clazz == null ? clazz2 != null : !clazz.equals(clazz2), (Function0 & Serializable & scala.Serializable)() -> "Should not create a log with type Seq, use Arrays instead - see SPARK-17372");
        this.metadataPath = new Path(path);
        this.fileManager = CheckpointFileManager$.MODULE$.create(this.metadataPath(), sparkSession.sessionState().newHadoopConf());
        if (!this.fileManager().exists(this.metadataPath())) {
            this.fileManager().mkdirs(this.metadataPath());
        }
        this.batchFilesFilter = new PathFilter(this){
            private final /* synthetic */ HDFSMetadataLog $outer;

            public boolean accept(Path path) {
                return this.$outer.isBatchFile(path);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }
}

