/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.internal;

import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.internal.config.OptionalConfigEntry;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.util.Utils$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class StaticSQLConf$ {
    public static StaticSQLConf$ MODULE$;
    private final ConfigEntry<String> WAREHOUSE_PATH;
    private final ConfigEntry<String> CATALOG_IMPLEMENTATION;
    private final ConfigEntry<String> GLOBAL_TEMP_DATABASE;
    private final ConfigEntry<Object> SCHEMA_STRING_LENGTH_THRESHOLD;
    private final ConfigEntry<Object> FILESOURCE_TABLE_RELATION_CACHE_SIZE;
    private final ConfigEntry<Object> CODEGEN_CACHE_MAX_ENTRIES;
    private final ConfigEntry<Object> CODEGEN_COMMENTS;
    private final ConfigEntry<Object> DEBUG_MODE;
    private final ConfigEntry<Object> HIVE_THRIFT_SERVER_SINGLESESSION;
    private final OptionalConfigEntry<String> SPARK_SESSION_EXTENSIONS;
    private final OptionalConfigEntry<Seq<String>> QUERY_EXECUTION_LISTENERS;
    private final OptionalConfigEntry<Seq<String>> STREAMING_QUERY_LISTENERS;
    private final ConfigEntry<Object> UI_RETAINED_EXECUTIONS;
    private final ConfigEntry<Object> SUBQUERY_MAX_THREAD_THRESHOLD;
    private final ConfigEntry<Object> DEFAULT_URL_STREAM_HANDLER_FACTORY_ENABLED;

    static {
        new StaticSQLConf$();
    }

    public ConfigEntry<String> WAREHOUSE_PATH() {
        return this.WAREHOUSE_PATH;
    }

    public ConfigEntry<String> CATALOG_IMPLEMENTATION() {
        return this.CATALOG_IMPLEMENTATION;
    }

    public ConfigEntry<String> GLOBAL_TEMP_DATABASE() {
        return this.GLOBAL_TEMP_DATABASE;
    }

    public ConfigEntry<Object> SCHEMA_STRING_LENGTH_THRESHOLD() {
        return this.SCHEMA_STRING_LENGTH_THRESHOLD;
    }

    public ConfigEntry<Object> FILESOURCE_TABLE_RELATION_CACHE_SIZE() {
        return this.FILESOURCE_TABLE_RELATION_CACHE_SIZE;
    }

    public ConfigEntry<Object> CODEGEN_CACHE_MAX_ENTRIES() {
        return this.CODEGEN_CACHE_MAX_ENTRIES;
    }

    public ConfigEntry<Object> CODEGEN_COMMENTS() {
        return this.CODEGEN_COMMENTS;
    }

    public ConfigEntry<Object> DEBUG_MODE() {
        return this.DEBUG_MODE;
    }

    public ConfigEntry<Object> HIVE_THRIFT_SERVER_SINGLESESSION() {
        return this.HIVE_THRIFT_SERVER_SINGLESESSION;
    }

    public OptionalConfigEntry<String> SPARK_SESSION_EXTENSIONS() {
        return this.SPARK_SESSION_EXTENSIONS;
    }

    public OptionalConfigEntry<Seq<String>> QUERY_EXECUTION_LISTENERS() {
        return this.QUERY_EXECUTION_LISTENERS;
    }

    public OptionalConfigEntry<Seq<String>> STREAMING_QUERY_LISTENERS() {
        return this.STREAMING_QUERY_LISTENERS;
    }

    public ConfigEntry<Object> UI_RETAINED_EXECUTIONS() {
        return this.UI_RETAINED_EXECUTIONS;
    }

    public ConfigEntry<Object> SUBQUERY_MAX_THREAD_THRESHOLD() {
        return this.SUBQUERY_MAX_THREAD_THRESHOLD;
    }

    public ConfigEntry<Object> DEFAULT_URL_STREAM_HANDLER_FACTORY_ENABLED() {
        return this.DEFAULT_URL_STREAM_HANDLER_FACTORY_ENABLED;
    }

    private StaticSQLConf$() {
        MODULE$ = this;
        this.WAREHOUSE_PATH = SQLConf$.MODULE$.buildStaticConf("spark.sql.warehouse.dir").doc("The default location for managed databases and tables.").stringConf().createWithDefault((Object)Utils$.MODULE$.resolveURI("spark-warehouse").toString());
        this.CATALOG_IMPLEMENTATION = SQLConf$.MODULE$.buildStaticConf("spark.sql.catalogImplementation").internal().stringConf().checkValues((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hive", "in-memory"}))).createWithDefault((Object)"in-memory");
        this.GLOBAL_TEMP_DATABASE = SQLConf$.MODULE$.buildStaticConf("spark.sql.globalTempDatabase").internal().stringConf().createWithDefault((Object)"global_temp");
        this.SCHEMA_STRING_LENGTH_THRESHOLD = SQLConf$.MODULE$.buildStaticConf("spark.sql.sources.schemaStringLengthThreshold").doc("The maximum length allowed in a single cell when storing additional schema information in Hive's metastore.").internal().intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)4000));
        this.FILESOURCE_TABLE_RELATION_CACHE_SIZE = SQLConf$.MODULE$.buildStaticConf("spark.sql.filesourceTableRelationCacheSize").internal().doc("The maximum size of the cache that maps qualified table names to table relation plans.").intConf().checkValue((Function1)(JFunction1.mcZI.sp & java.io.Serializable & Serializable)cacheSize -> cacheSize >= 0, "The maximum size of the cache must not be negative").createWithDefault((Object)BoxesRunTime.boxToInteger((int)1000));
        this.CODEGEN_CACHE_MAX_ENTRIES = SQLConf$.MODULE$.buildStaticConf("spark.sql.codegen.cache.maxEntries").internal().doc("When nonzero, enable caching of generated classes for operators and expressions. All jobs share the cache that can use up to the specified number for generated classes.").intConf().checkValue((Function1)(JFunction1.mcZI.sp & java.io.Serializable & Serializable)maxEntries -> maxEntries >= 0, "The maximum must not be negative").createWithDefault((Object)BoxesRunTime.boxToInteger((int)100));
        this.CODEGEN_COMMENTS = SQLConf$.MODULE$.buildStaticConf("spark.sql.codegen.comments").internal().doc("When true, put comment in the generated code. Since computing huge comments can be extremely expensive in certain cases, such as deeply-nested expressions which operate over inputs with wide schemas, default is false.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.DEBUG_MODE = SQLConf$.MODULE$.buildStaticConf("spark.sql.debug").internal().doc("Only used for internal debugging. Not all functions are supported when it is enabled.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.HIVE_THRIFT_SERVER_SINGLESESSION = SQLConf$.MODULE$.buildStaticConf("spark.sql.hive.thriftServer.singleSession").doc("When set to true, Hive Thrift server is running in a single session mode. All the JDBC/ODBC connections share the temporary views, function registries, SQL configuration and the current database.").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
        this.SPARK_SESSION_EXTENSIONS = SQLConf$.MODULE$.buildStaticConf("spark.sql.extensions").doc("Name of the class used to configure Spark Session extensions. The class should implement Function1[SparkSessionExtension, Unit], and must have a no-args constructor.").stringConf().createOptional();
        this.QUERY_EXECUTION_LISTENERS = SQLConf$.MODULE$.buildStaticConf("spark.sql.queryExecutionListeners").doc("List of class names implementing QueryExecutionListener that will be automatically added to newly created sessions. The classes should have either a no-arg constructor, or a constructor that expects a SparkConf argument.").stringConf().toSequence().createOptional();
        this.STREAMING_QUERY_LISTENERS = SQLConf$.MODULE$.buildStaticConf("spark.sql.streaming.streamingQueryListeners").doc("List of class names implementing StreamingQueryListener that will be automatically added to newly created sessions. The classes should have either a no-arg constructor, or a constructor that expects a SparkConf argument.").stringConf().toSequence().createOptional();
        this.UI_RETAINED_EXECUTIONS = SQLConf$.MODULE$.buildStaticConf("spark.sql.ui.retainedExecutions").doc("Number of executions to retain in the Spark UI.").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)1000));
        this.SUBQUERY_MAX_THREAD_THRESHOLD = SQLConf$.MODULE$.buildStaticConf("spark.sql.subquery.maxThreadThreshold").internal().doc("The maximum degree of parallelism to execute the subquery.").intConf().checkValue((Function1)(JFunction1.mcZI.sp & java.io.Serializable & Serializable)thres -> thres > 0 && thres <= 128, "The threshold must be in (0,128].").createWithDefault((Object)BoxesRunTime.boxToInteger((int)16));
        this.DEFAULT_URL_STREAM_HANDLER_FACTORY_ENABLED = SQLConf$.MODULE$.buildStaticConf("spark.sql.defaultUrlStreamHandlerFactory.enabled").doc("When true, set FsUrlStreamHandlerFactory to support ADD JAR against HDFS locations").internal().booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
    }
}

