/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.xml;

import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.xml.XPathExtract;
import org.apache.spark.sql.catalyst.expressions.xml.XPathLong$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(xml, xpath) - Returns a long integer value, or the value zero if no match is found, or a match is found but the value is non-numeric.", examples="\n    Examples:\n      > SELECT _FUNC_('<a><b>1</b><b>2</b></a>', 'sum(a/b)');\n       3\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005md\u0001B\r\u001b\u0001&B\u0001b\u0007\u0001\u0003\u0016\u0004%\ta\u000e\u0005\ty\u0001\u0011\t\u0012)A\u0005q!AQ\b\u0001BK\u0002\u0013\u0005q\u0007\u0003\u0005?\u0001\tE\t\u0015!\u00039\u0011\u0015y\u0004\u0001\"\u0001A\u0011\u0015!\u0005\u0001\"\u0011F\u0011\u0015\t\u0006\u0001\"\u0011S\u0011\u0015I\u0006\u0001\"\u0011[\u0011\u001d\u0001\u0007!!A\u0005\u0002\u0005Dq\u0001\u001a\u0001\u0012\u0002\u0013\u0005Q\rC\u0004q\u0001E\u0005I\u0011A3\t\u000fE\u0004\u0011\u0011!C!e\"9!\u0010AA\u0001\n\u0003Y\b\u0002C@\u0001\u0003\u0003%\t!!\u0001\t\u0013\u0005\u001d\u0001!!A\u0005B\u0005%\u0001\"CA\f\u0001\u0005\u0005I\u0011AA\r\u0011%\t\u0019\u0003AA\u0001\n\u0003\n)cB\u0005\u0002>i\t\t\u0011#\u0001\u0002@\u0019A\u0011DGA\u0001\u0012\u0003\t\t\u0005\u0003\u0004@'\u0011\u0005\u0011q\n\u0005\n\u0003#\u001a\u0012\u0011!C#\u0003'B\u0011\"!\u0016\u0014\u0003\u0003%\t)a\u0016\t\u0013\u0005u3#!A\u0005\u0002\u0006}\u0003\"CA9'\u0005\u0005I\u0011BA:\u0005%A\u0006+\u0019;i\u0019>twM\u0003\u0002\u001c9\u0005\u0019\u00010\u001c7\u000b\u0005uq\u0012aC3yaJ,7o]5p]NT!a\b\u0011\u0002\u0011\r\fG/\u00197zgRT!!\t\u0012\u0002\u0007M\fHN\u0003\u0002$I\u0005)1\u000f]1sW*\u0011QEJ\u0001\u0007CB\f7\r[3\u000b\u0003\u001d\n1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\u0016/iA\u00111\u0006L\u0007\u00025%\u0011QF\u0007\u0002\r1B\u000bG\u000f[#yiJ\f7\r\u001e\t\u0003_Ij\u0011\u0001\r\u0006\u0002c\u0005)1oY1mC&\u00111\u0007\r\u0002\b!J|G-^2u!\tyS'\u0003\u00027a\ta1+\u001a:jC2L'0\u00192mKV\t\u0001\b\u0005\u0002:u5\tA$\u0003\u0002<9\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\talG\u000eI\u0001\u0005a\u0006$\b.A\u0003qCRD\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0004\u0003\n\u001b\u0005CA\u0016\u0001\u0011\u0015YR\u00011\u00019\u0011\u0015iT\u00011\u00019\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0002\rB\u0011qI\u0014\b\u0003\u00112\u0003\"!\u0013\u0019\u000e\u0003)S!a\u0013\u0015\u0002\rq\u0012xn\u001c;?\u0013\ti\u0005'\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u001fB\u0013aa\u0015;sS:<'BA'1\u0003!!\u0017\r^1UsB,W#A*\u0011\u0005Q;V\"A+\u000b\u0005Y\u0003\u0013!\u0002;za\u0016\u001c\u0018B\u0001-V\u0005!!\u0015\r^1UsB,\u0017\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dGcA._?B\u0011q\u0006X\u0005\u0003;B\u00121!\u00118z\u0011\u0015Y\u0002\u00021\u0001\\\u0011\u0015i\u0004\u00021\u0001\\\u0003\u0011\u0019w\u000e]=\u0015\u0007\u0005\u00137\rC\u0004\u001c\u0013A\u0005\t\u0019\u0001\u001d\t\u000fuJ\u0001\u0013!a\u0001q\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nT#\u00014+\u0005a:7&\u00015\u0011\u0005%tW\"\u00016\u000b\u0005-d\u0017!C;oG\",7m[3e\u0015\ti\u0007'\u0001\u0006b]:|G/\u0019;j_:L!a\u001c6\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\u0005\u0019\bC\u0001;z\u001b\u0005)(B\u0001<x\u0003\u0011a\u0017M\\4\u000b\u0003a\fAA[1wC&\u0011q*^\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0002yB\u0011q&`\u0005\u0003}B\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$2aWA\u0002\u0011!\t)ADA\u0001\u0002\u0004a\u0018a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002\fA)\u0011QBA\n76\u0011\u0011q\u0002\u0006\u0004\u0003#\u0001\u0014AC2pY2,7\r^5p]&!\u0011QCA\b\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005m\u0011\u0011\u0005\t\u0004_\u0005u\u0011bAA\u0010a\t9!i\\8mK\u0006t\u0007\u0002CA\u0003!\u0005\u0005\t\u0019A.\u0002\r\u0015\fX/\u00197t)\u0011\tY\"a\n\t\u0011\u0005\u0015\u0011#!AA\u0002mC3\u0002AA\u0016\u0003c\t\u0019$a\u000e\u0002:A\u0019\u0011(!\f\n\u0007\u0005=BDA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005U\u0012!!\u0007`\rVs5i\u0018\u0015y[2d\u0003\u0005\u001f9bi\"L\u0003%\f\u0011SKR,(O\\:!C\u0002bwN\\4!S:$XmZ3sAY\fG.^3-A=\u0014\b\u0005\u001e5fAY\fG.^3!u\u0016\u0014x\u000eI5gA9|\u0007%\\1uG\"\u0004\u0013n\u001d\u0011g_VtG\r\f\u0011pe\u0002\n\u0007%\\1uG\"\u0004\u0013n\u001d\u0011g_VtG\r\t2vi\u0002\"\b.\u001a\u0011wC2,X\rI5tA9|g.\f8v[\u0016\u0014\u0018n\u0019\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!a\u000f\u00021*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs\u0005P1?y\tt\u0014\u0007P\u0018c}q\u0012gH\r\u001f0Ezbt&\u0019 (Y\u0001:3/^7)C>\u0012\u0017fJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AMR\u0001\u0005I\u0001\n1B\u000bG\u000f\u001b'p]\u001e\u0004\"aK\n\u0014\tM\t\u0019\u0005\u000e\t\b\u0003\u000b\nY\u0005\u000f\u001dB\u001b\t\t9EC\u0002\u0002JA\nqA];oi&lW-\u0003\u0003\u0002N\u0005\u001d#!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeQ\u0011\u0011qH\u0001\ti>\u001cFO]5oOR\t1/A\u0003baBd\u0017\u0010F\u0003B\u00033\nY\u0006C\u0003\u001c-\u0001\u0007\u0001\bC\u0003>-\u0001\u0007\u0001(A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005\u0005\u0014Q\u000e\t\u0006_\u0005\r\u0014qM\u0005\u0004\u0003K\u0002$AB(qi&|g\u000eE\u00030\u0003SB\u0004(C\u0002\u0002lA\u0012a\u0001V;qY\u0016\u0014\u0004\u0002CA8/\u0005\u0005\t\u0019A!\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GCAA;!\r!\u0018qO\u0005\u0004\u0003s*(AB(cU\u0016\u001cG\u000f")
public class XPathLong
extends XPathExtract
implements Serializable {
    private final Expression xml;
    private final Expression path;

    public static Option<Tuple2<Expression, Expression>> unapply(XPathLong xPathLong) {
        return XPathLong$.MODULE$.unapply(xPathLong);
    }

    public static Function1<Tuple2<Expression, Expression>, XPathLong> tupled() {
        return XPathLong$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, XPathLong>> curried() {
        return XPathLong$.MODULE$.curried();
    }

    @Override
    public Expression xml() {
        return this.xml;
    }

    @Override
    public Expression path() {
        return this.path;
    }

    @Override
    public String prettyName() {
        return "xpath_long";
    }

    @Override
    public DataType dataType() {
        return LongType$.MODULE$;
    }

    @Override
    public Object nullSafeEval(Object xml, Object path) {
        Double ret = this.xpathUtil().evalNumber(((UTF8String)xml).toString(), this.pathString());
        return ret == null ? null : BoxesRunTime.boxToLong((long)ret.longValue());
    }

    public XPathLong copy(Expression xml, Expression path) {
        return new XPathLong(xml, path);
    }

    public Expression copy$default$1() {
        return this.xml();
    }

    public Expression copy$default$2() {
        return this.path();
    }

    @Override
    public String productPrefix() {
        return "XPathLong";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.xml();
                break;
            }
            case 1: {
                expression = this.path();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof XPathLong;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof XPathLong)) return false;
        boolean bl = true;
        if (!bl) return false;
        XPathLong xPathLong = (XPathLong)x$1;
        Expression expression = this.xml();
        Expression expression2 = xPathLong.xml();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.path();
        Expression expression4 = xPathLong.path();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!xPathLong.canEqual(this)) return false;
        return true;
    }

    public XPathLong(Expression xml, Expression path) {
        this.xml = xml;
        this.path = path;
    }
}

