/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.String2TrimExpression;
import org.apache.spark.sql.catalyst.expressions.StringTrimRight$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(str) - Removes the trailing space characters from `str`.\n\n    _FUNC_(trimStr, str) - Removes the trailing string which contains the characters from the trim string from the `str`\n  ", arguments="\n    Arguments:\n      * str - a string expression\n      * trimStr - the trim string characters to trim, the default value is a single space\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('    SparkSQL   ');\n       SparkSQL\n      > SELECT _FUNC_('LQSa', 'SSparkSQLS');\n       SSpark\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005mv!\u0002\u0010 \u0011\u0003ac!\u0002\u0018 \u0011\u0003y\u0003\"B\u001d\u0002\t\u0003Q\u0004\"B\u001e\u0002\t\u0003a\u0004BB\u001e\u0002\t\u0003\t\u0019\n\u0003\u0005<\u0003\u0005\u0005I\u0011QAL\u0011%\ti*AI\u0001\n\u0003\t\u0019\u0003C\u0005\u0002 \u0006\t\t\u0011\"!\u0002\"\"I\u0011qV\u0001\u0012\u0002\u0013\u0005\u00111\u0005\u0005\n\u0003c\u000b\u0011\u0011!C\u0005\u0003g3AAL\u0010A}!A\u0001J\u0003BK\u0002\u0013\u0005\u0011\n\u0003\u0005K\u0015\tE\t\u0015!\u0003@\u0011!Y%B!f\u0001\n\u0003a\u0005\u0002\u0003)\u000b\u0005#\u0005\u000b\u0011B'\t\u000beRA\u0011A)\t\u000beRA\u0011\u0001+\t\u000beRA\u0011A,\t\u000beSA\u0011\t.\t\u000b\u0019TA\u0011I4\t\u000bETA\u0011\u000b:\t\u0013\u0005\u0005!\"!A\u0005\u0002\u0005\r\u0001\"CA\u0005\u0015E\u0005I\u0011AA\u0006\u0011%\t\tCCI\u0001\n\u0003\t\u0019\u0003C\u0005\u0002()\t\t\u0011\"\u0011\u0002*!I\u0011\u0011\b\u0006\u0002\u0002\u0013\u0005\u00111\b\u0005\n\u0003\u0007R\u0011\u0011!C\u0001\u0003\u000bB\u0011\"a\u0013\u000b\u0003\u0003%\t%!\u0014\t\u0013\u0005m#\"!A\u0005\u0002\u0005u\u0003\"CA4\u0015\u0005\u0005I\u0011IA5\u0003=\u0019FO]5oOR\u0013\u0018.\u001c*jO\"$(B\u0001\u0011\"\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\t\u001a\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u0011*\u0013aA:rY*\u0011aeJ\u0001\u0006gB\f'o\u001b\u0006\u0003Q%\na!\u00199bG\",'\"\u0001\u0016\u0002\u0007=\u0014xm\u0001\u0001\u0011\u00055\nQ\"A\u0010\u0003\u001fM#(/\u001b8h)JLWNU5hQR\u001c2!\u0001\u00197!\t\tD'D\u00013\u0015\u0005\u0019\u0014!B:dC2\f\u0017BA\u001b3\u0005\u0019\te.\u001f*fMB\u0011\u0011gN\u0005\u0003qI\u0012AbU3sS\u0006d\u0017N_1cY\u0016\fa\u0001P5oSRtD#\u0001\u0017\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000bu\ni)!%\u0011\u00055R1#\u0002\u0006@\u0005\u00163\u0004CA\u0017A\u0013\t\tuD\u0001\u0006FqB\u0014Xm]:j_:\u0004\"!L\"\n\u0005\u0011{\"!F*ue&twM\r+sS6,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003c\u0019K!a\u0012\u001a\u0003\u000fA\u0013x\u000eZ;di\u000611O]2TiJ,\u0012aP\u0001\bgJ\u001c7\u000b\u001e:!\u0003\u001d!(/[7TiJ,\u0012!\u0014\t\u0004c9{\u0014BA(3\u0005\u0019y\u0005\u000f^5p]\u0006AAO]5n'R\u0014\b\u0005F\u0002>%NCQ\u0001S\bA\u0002}BqaS\b\u0011\u0002\u0003\u0007Q\nF\u0002>+ZCQa\u0013\tA\u0002}BQ\u0001\u0013\tA\u0002}\"\"!\u0010-\t\u000b!\u000b\u0002\u0019A \u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001\\!\ta6M\u0004\u0002^CB\u0011aLM\u0007\u0002?*\u0011\u0001mK\u0001\u0007yI|w\u000e\u001e \n\u0005\t\u0014\u0014A\u0002)sK\u0012,g-\u0003\u0002eK\n11\u000b\u001e:j]\u001eT!A\u0019\u001a\u0002\t\u00154\u0018\r\u001c\u000b\u0003Q.\u0004\"!M5\n\u0005)\u0014$aA!os\"9An\u0005I\u0001\u0002\u0004i\u0017!B5oaV$\bC\u00018p\u001b\u0005\t\u0013B\u00019\"\u0005-Ie\u000e^3s]\u0006d'k\\<\u0002\u0013\u0011|w)\u001a8D_\u0012,GcA:z}B\u0011Ao^\u0007\u0002k*\u0011aoH\u0001\bG>$WmZ3o\u0013\tAXO\u0001\u0005FqB\u00148i\u001c3f\u0011\u0015QH\u00031\u0001|\u0003\r\u0019G\u000f\u001f\t\u0003irL!!`;\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\")q\u0010\u0006a\u0001g\u0006\u0011QM^\u0001\u0005G>\u0004\u0018\u0010F\u0003>\u0003\u000b\t9\u0001C\u0004I+A\u0005\t\u0019A \t\u000f-+\u0002\u0013!a\u0001\u001b\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u0007U\ry\u0014qB\u0016\u0003\u0003#\u0001B!a\u0005\u0002\u001e5\u0011\u0011Q\u0003\u0006\u0005\u0003/\tI\"A\u0005v]\u000eDWmY6fI*\u0019\u00111\u0004\u001a\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002 \u0005U!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAA\u0013U\ri\u0015qB\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005-\u0002\u0003BA\u0017\u0003oi!!a\f\u000b\t\u0005E\u00121G\u0001\u0005Y\u0006twM\u0003\u0002\u00026\u0005!!.\u0019<b\u0013\r!\u0017qF\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003{\u00012!MA \u0013\r\t\tE\r\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004Q\u0006\u001d\u0003\"CA%5\u0005\u0005\t\u0019AA\u001f\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\n\t\u0006\u0003#\n9\u0006[\u0007\u0003\u0003'R1!!\u00163\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u00033\n\u0019F\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA0\u0003K\u00022!MA1\u0013\r\t\u0019G\r\u0002\b\u0005>|G.Z1o\u0011!\tI\u0005HA\u0001\u0002\u0004A\u0017AB3rk\u0006d7\u000f\u0006\u0003\u0002`\u0005-\u0004\u0002CA%;\u0005\u0005\t\u0019\u00015)')\ty'!\u001e\u0002x\u0005m\u0014QPAA\u0003\u0007\u000b9)!#\u0011\u00075\n\t(C\u0002\u0002t}\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002z\u0005\t\u0019I\u0003\u0011!A\u0001zf)\u0016(D?\"\u001aHO]\u0015![\u0001\u0012V-\\8wKN\u0004C\u000f[3!iJ\f\u0017\u000e\\5oO\u0002\u001a\b/Y2fA\rD\u0017M]1di\u0016\u00148\u000f\t4s_6\u0004\u0003m\u001d;sA:R!\u0002\t\u0011!A}3UKT\"`QQ\u0014\u0018.\\*ue2\u00023\u000f\u001e:*A5\u0002#+Z7pm\u0016\u001c\b\u0005\u001e5fAQ\u0014\u0018-\u001b7j]\u001e\u00043\u000f\u001e:j]\u001e\u0004s\u000f[5dQ\u0002\u001awN\u001c;bS:\u001c\b\u0005\u001e5fA\rD\u0017M]1di\u0016\u00148\u000f\t4s_6\u0004C\u000f[3!iJLW\u000eI:ue&tw\r\t4s_6\u0004C\u000f[3!AN$(\u000f\u0019\u0006!A\u0005I\u0011M]4v[\u0016tGo]\u0011\u0003\u0003\u007f\n\u0011Q\u0004\u0006!A\u0001\u0002\u0013I]4v[\u0016tGo\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011+AM$(\u000fI\u0017!C\u0002\u001aHO]5oO\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0006!A\u0001\u0002\u0003\u0005\t\u0016!iJLWn\u0015;sA5\u0002C\u000f[3!iJLW\u000eI:ue&tw\rI2iCJ\f7\r^3sg\u0002\"x\u000e\t;sS6d\u0003\u0005\u001e5fA\u0011,g-Y;mi\u00022\u0018\r\\;fA%\u001c\b%\u0019\u0011tS:<G.\u001a\u0011ta\u0006\u001cWM\u0003\u0011!\u0003!)\u00070Y7qY\u0016\u001c\u0018EAAC\u0003\u00055!\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u0014!A\u0001\u00023\u000b]1sWN\u000bF\n\t\u0011!O%Z$\u0002\t\u0011!A\u0001\u0002\u0003e\u00159be.\u001c\u0016\u000b\u0014\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)O1\u000b6+Y\u0014-A\u001d\u001a6\u000b]1sWN\u000bFjU\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u001a6\u000b]1sW*\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0002\f\u0006)\u0011GL\u001b/a!1\u0011qR\u0002A\u0002}\n1a\u001d;s\u0011\u0015Y5\u00011\u0001@)\ri\u0014Q\u0013\u0005\u0007\u0003\u001f#\u0001\u0019A \u0015\u000bu\nI*a'\t\u000b!+\u0001\u0019A \t\u000f-+\u0001\u0013!a\u0001\u001b\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$#'A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005\r\u00161\u0016\t\u0005c9\u000b)\u000bE\u00032\u0003O{T*C\u0002\u0002*J\u0012a\u0001V;qY\u0016\u0014\u0004\u0002CAW\u000f\u0005\u0005\t\u0019A\u001f\u0002\u0007a$\u0003'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u00026B!\u0011QFA\\\u0013\u0011\tI,a\f\u0003\r=\u0013'.Z2u\u0001")
public class StringTrimRight
extends Expression
implements String2TrimExpression,
scala.Serializable {
    private final Expression srcStr;
    private final Option<Expression> trimStr;

    public static Option<Expression> $lessinit$greater$default$2() {
        return StringTrimRight$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Option<Expression>>> unapply(StringTrimRight stringTrimRight) {
        return StringTrimRight$.MODULE$.unapply(stringTrimRight);
    }

    public static Option<Expression> apply$default$2() {
        return StringTrimRight$.MODULE$.apply$default$2();
    }

    @Override
    public /* synthetic */ String org$apache$spark$sql$catalyst$expressions$String2TrimExpression$$super$sql() {
        return super.sql();
    }

    @Override
    public Seq<Expression> children() {
        return String2TrimExpression.children$(this);
    }

    @Override
    public DataType dataType() {
        return String2TrimExpression.dataType$(this);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return String2TrimExpression.inputTypes$(this);
    }

    @Override
    public boolean nullable() {
        return String2TrimExpression.nullable$(this);
    }

    @Override
    public boolean foldable() {
        return String2TrimExpression.foldable$(this);
    }

    @Override
    public String sql() {
        return String2TrimExpression.sql$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression srcStr() {
        return this.srcStr;
    }

    @Override
    public Option<Expression> trimStr() {
        return this.trimStr;
    }

    @Override
    public String prettyName() {
        return "rtrim";
    }

    @Override
    public Object eval(InternalRow input) {
        UTF8String srcString = (UTF8String)this.srcStr().eval(input);
        return srcString == null ? null : (this.trimStr().isDefined() ? srcString.trimRight((UTF8String)((Expression)this.trimStr().get()).eval(input)) : srcString.trimRight());
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        Seq evals = (Seq)this.children().map((Function1 & Serializable & scala.Serializable)x$36 -> x$36.genCode(ctx), Seq$.MODULE$.canBuildFrom());
        ExprCode srcString = (ExprCode)evals.apply(0);
        if (evals.length() == 1) {
            exprCode = ev.copy(Block$.MODULE$.blocksToBlock((Seq<Block>)((Seq)((SeqLike)evals.map((Function1 & Serializable & scala.Serializable)x$37 -> x$37.code(), Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        boolean ", " = false;\n        UTF8String ", " = null;\n        if (", ") {\n          ", " = true;\n        } else {\n          ", " = ", ".trimRight();\n        }"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), ev.value(), srcString.isNull(), ev.isNull(), ev.value(), srcString.value()})), Seq$.MODULE$.canBuildFrom()))), ev.copy$default$2(), ev.copy$default$3());
        } else {
            ExprCode trimString = (ExprCode)evals.apply(1);
            String getTrimRightFunction = new StringBuilder(89).append("\n        if (").append(trimString.isNull()).append(") {\n          ").append(ev.isNull()).append(" = true;\n        } else {\n          ").append(ev.value()).append(" = ").append(srcString.value()).append(".trimRight(").append(trimString.value()).append(");\n        }").toString();
            exprCode = ev.copy(Block$.MODULE$.blocksToBlock((Seq<Block>)((Seq)((SeqLike)evals.map((Function1 & Serializable & scala.Serializable)x$38 -> x$38.code(), Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        boolean ", " = false;\n        UTF8String ", " = null;\n        if (", ") {\n          ", " = true;\n        } else {\n          ", "\n        }"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), ev.value(), srcString.isNull(), ev.isNull(), getTrimRightFunction})), Seq$.MODULE$.canBuildFrom()))), ev.copy$default$2(), ev.copy$default$3());
        }
        return exprCode;
    }

    public StringTrimRight copy(Expression srcStr, Option<Expression> trimStr) {
        return new StringTrimRight(srcStr, trimStr);
    }

    public Expression copy$default$1() {
        return this.srcStr();
    }

    public Option<Expression> copy$default$2() {
        return this.trimStr();
    }

    @Override
    public String productPrefix() {
        return "StringTrimRight";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Option<Expression> option;
        int n = x$1;
        switch (n) {
            case 0: {
                option = this.srcStr();
                break;
            }
            case 1: {
                option = this.trimStr();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return option;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringTrimRight;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringTrimRight)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringTrimRight stringTrimRight = (StringTrimRight)x$1;
        Expression expression = this.srcStr();
        Expression expression2 = stringTrimRight.srcStr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.trimStr();
        Option<Expression> option2 = stringTrimRight.trimStr();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!stringTrimRight.canEqual(this)) return false;
        return true;
    }

    public StringTrimRight(Expression srcStr, Option<Expression> trimStr) {
        this.srcStr = srcStr;
        this.trimStr = trimStr;
        ExpectsInputTypes.$init$(this);
        String2TrimExpression.$init$(this);
    }

    public StringTrimRight(Expression trimStr, Expression srcStr) {
        this(srcStr, (Option<Expression>)Option$.MODULE$.apply((Object)trimStr));
    }

    public StringTrimRight(Expression srcStr) {
        this(srcStr, (Option<Expression>)None$.MODULE$);
    }
}

