/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.StringSplit$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(str, regex) - Splits `str` around occurrences that match `regex`.", examples="\n    Examples:\n      > SELECT _FUNC_('oneAtwoBthreeC', '[ABC]');\n       [\"one\",\"two\",\"three\",\"\"]\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005\u001dg\u0001B\u000f\u001f\u0001.B\u0001\u0002\u0010\u0001\u0003\u0016\u0004%\t!\u0010\u0005\t\u0003\u0002\u0011\t\u0012)A\u0005}!A!\t\u0001BK\u0002\u0013\u0005Q\b\u0003\u0005D\u0001\tE\t\u0015!\u0003?\u0011\u0015!\u0005\u0001\"\u0001F\u0011\u0015I\u0005\u0001\"\u0011>\u0011\u0015Q\u0005\u0001\"\u0011>\u0011\u0015Y\u0005\u0001\"\u0011M\u0011\u0015\u0019\u0006\u0001\"\u0011U\u0011\u0015\t\u0007\u0001\"\u0011c\u0011\u0015Q\u0007\u0001\"\u0011l\u0011\u0015I\b\u0001\"\u0011{\u0011%\t9\u0001AA\u0001\n\u0003\tI\u0001C\u0005\u0002\u0010\u0001\t\n\u0011\"\u0001\u0002\u0012!I\u0011q\u0005\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u0003\u0005\n\u0003S\u0001\u0011\u0011!C!\u0003WA\u0011\"a\u000f\u0001\u0003\u0003%\t!!\u0010\t\u0013\u0005\u0015\u0003!!A\u0005\u0002\u0005\u001d\u0003\"CA'\u0001\u0005\u0005I\u0011IA(\u0011%\ti\u0006AA\u0001\n\u0003\ty\u0006C\u0005\u0002j\u0001\t\t\u0011\"\u0011\u0002l\u001dI\u0011\u0011\u0012\u0010\u0002\u0002#\u0005\u00111\u0012\u0004\t;y\t\t\u0011#\u0001\u0002\u000e\"1Ai\u0006C\u0001\u00037C\u0011\"!(\u0018\u0003\u0003%)%a(\t\u0013\u0005\u0005v#!A\u0005\u0002\u0006\r\u0006\"CAU/\u0005\u0005I\u0011QAV\u0011%\tilFA\u0001\n\u0013\tyLA\u0006TiJLgnZ*qY&$(BA\u0010!\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u0005\u0012\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\r\"\u0013aA:rY*\u0011QEJ\u0001\u0006gB\f'o\u001b\u0006\u0003O!\na!\u00199bG\",'\"A\u0015\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001a\u0003gM\u001d\u0011\u00055rS\"\u0001\u0010\n\u0005=r\"\u0001\u0005\"j]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\ti\u0013'\u0003\u00023=\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u00025o5\tQGC\u00017\u0003\u0015\u00198-\u00197b\u0013\tATGA\u0004Qe>$Wo\u0019;\u0011\u0005QR\u0014BA\u001e6\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\r\u0019HO]\u000b\u0002}A\u0011QfP\u0005\u0003\u0001z\u0011!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0011\u0019HO\u001d\u0011\u0002\u000fA\fG\u000f^3s]\u0006A\u0001/\u0019;uKJt\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0004\r\u001eC\u0005CA\u0017\u0001\u0011\u0015aT\u00011\u0001?\u0011\u0015\u0011U\u00011\u0001?\u0003\u0011aWM\u001a;\u0002\u000bILw\r\u001b;\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012!\u0014\t\u0003\u001dFk\u0011a\u0014\u0006\u0003!\n\nQ\u0001^=qKNL!AU(\u0003\u0011\u0011\u000bG/\u0019+za\u0016\f!\"\u001b8qkR$\u0016\u0010]3t+\u0005)\u0006c\u0001,_\u001b:\u0011q\u000b\u0018\b\u00031nk\u0011!\u0017\u0006\u00035*\na\u0001\u0010:p_Rt\u0014\"\u0001\u001c\n\u0005u+\u0014a\u00029bG.\fw-Z\u0005\u0003?\u0002\u00141aU3r\u0015\tiV'\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000eF\u0002dM\"\u0004\"\u0001\u000e3\n\u0005\u0015,$aA!os\")qM\u0003a\u0001G\u000611\u000f\u001e:j]\u001eDQ!\u001b\u0006A\u0002\r\fQA]3hKb\f\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\u00071\u0014x\u000f\u0005\u0002na6\taN\u0003\u0002p=\u000591m\u001c3fO\u0016t\u0017BA9o\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007\"B:\f\u0001\u0004!\u0018aA2uqB\u0011Q.^\u0005\u0003m:\u0014abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0003y\u0017\u0001\u0007A.\u0001\u0002fm\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0003m\u00042\u0001`A\u0001\u001d\tih\u0010\u0005\u0002Yk%\u0011q0N\u0001\u0007!J,G-\u001a4\n\t\u0005\r\u0011Q\u0001\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005},\u0014\u0001B2paf$RARA\u0006\u0003\u001bAq\u0001P\u0007\u0011\u0002\u0003\u0007a\bC\u0004C\u001bA\u0005\t\u0019\u0001 \u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u00111\u0003\u0016\u0004}\u0005U1FAA\f!\u0011\tI\"a\t\u000e\u0005\u0005m!\u0002BA\u000f\u0003?\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0005R'\u0001\u0006b]:|G/\u0019;j_:LA!!\n\u0002\u001c\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!!\f\u0011\t\u0005=\u0012\u0011H\u0007\u0003\u0003cQA!a\r\u00026\u0005!A.\u00198h\u0015\t\t9$\u0001\u0003kCZ\f\u0017\u0002BA\u0002\u0003c\tA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a\u0010\u0011\u0007Q\n\t%C\u0002\u0002DU\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$2aYA%\u0011%\tYEEA\u0001\u0002\u0004\ty$A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003#\u0002R!a\u0015\u0002Z\rl!!!\u0016\u000b\u0007\u0005]S'\u0001\u0006d_2dWm\u0019;j_:LA!a\u0017\u0002V\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t\t'a\u001a\u0011\u0007Q\n\u0019'C\u0002\u0002fU\u0012qAQ8pY\u0016\fg\u000e\u0003\u0005\u0002LQ\t\t\u00111\u0001d\u0003\u0019)\u0017/^1mgR!\u0011\u0011MA7\u0011!\tY%FA\u0001\u0002\u0004\u0019\u0007f\u0004\u0001\u0002r\u0005]\u0014\u0011PA?\u0003\u007f\n\u0019)!\"\u0011\u00075\n\u0019(C\u0002\u0002vy\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002|\u0005AuLR+O\u0007~C3\u000f\u001e:-AI,w-\u001a=*A5\u00023\u000b\u001d7jiN\u0004\u0003m\u001d;sA\u0002\n'o\\;oI\u0002z7mY;se\u0016t7-Z:!i\"\fG\u000fI7bi\u000eD\u0007\u0005\u0019:fO\u0016D\bML\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011\u0011Q\u0001d\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":sN\\3Bi^|'\t\u001e5sK\u0016\u001cu\u0005\f\u0011(7\u0006\u00135)X\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001Z&e\u001c8fE1\u0012Co^8#Y\t\"\bN]3fE1\u0012#%\u0018\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u0011qQ\u0001\u0006c9*d\u0006M\u0001\f'R\u0014\u0018N\\4Ta2LG\u000f\u0005\u0002./M!q#a$:!\u001d\t\t*a&?}\u0019k!!a%\u000b\u0007\u0005UU'A\u0004sk:$\u0018.\\3\n\t\u0005e\u00151\u0013\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014DCAAF\u0003!!xn\u0015;sS:<GCAA\u0017\u0003\u0015\t\u0007\u000f\u001d7z)\u00151\u0015QUAT\u0011\u0015a$\u00041\u0001?\u0011\u0015\u0011%\u00041\u0001?\u0003\u001d)h.\u00199qYf$B!!,\u0002:B)A'a,\u00024&\u0019\u0011\u0011W\u001b\u0003\r=\u0003H/[8o!\u0015!\u0014Q\u0017 ?\u0013\r\t9,\u000e\u0002\u0007)V\u0004H.\u001a\u001a\t\u0011\u0005m6$!AA\u0002\u0019\u000b1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005\u0005\u0007\u0003BA\u0018\u0003\u0007LA!!2\u00022\t1qJ\u00196fGR\u0004")
public class StringSplit
extends BinaryExpression
implements ImplicitCastInputTypes,
scala.Serializable {
    private final Expression str;
    private final Expression pattern;

    public static Option<Tuple2<Expression, Expression>> unapply(StringSplit stringSplit) {
        return StringSplit$.MODULE$.unapply(stringSplit);
    }

    public static Function1<Tuple2<Expression, Expression>, StringSplit> tupled() {
        return StringSplit$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, StringSplit>> curried() {
        return StringSplit$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression str() {
        return this.str;
    }

    public Expression pattern() {
        return this.pattern;
    }

    @Override
    public Expression left() {
        return this.str();
    }

    @Override
    public Expression right() {
        return this.pattern();
    }

    @Override
    public DataType dataType() {
        return ArrayType$.MODULE$.apply(StringType$.MODULE$);
    }

    public Seq<DataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StringType$[]{StringType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public Object nullSafeEval(Object string, Object regex) {
        UTF8String[] strings = ((UTF8String)string).split((UTF8String)regex, -1);
        return new GenericArrayData(strings);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String arrayClass = GenericArrayData.class.getName();
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(str, pattern) -> new StringBuilder(22).append(ev.value()).append(" = new ").append(arrayClass).append("(").append((String)str).append(".split(").append((String)pattern).append(", -1));").toString());
    }

    @Override
    public String prettyName() {
        return "split";
    }

    public StringSplit copy(Expression str, Expression pattern) {
        return new StringSplit(str, pattern);
    }

    public Expression copy$default$1() {
        return this.str();
    }

    public Expression copy$default$2() {
        return this.pattern();
    }

    @Override
    public String productPrefix() {
        return "StringSplit";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.str();
                break;
            }
            case 1: {
                expression = this.pattern();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringSplit;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringSplit)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringSplit stringSplit = (StringSplit)x$1;
        Expression expression = this.str();
        Expression expression2 = stringSplit.str();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.pattern();
        Expression expression4 = stringSplit.pattern();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!stringSplit.canEqual(this)) return false;
        return true;
    }

    public StringSplit(Expression str, Expression pattern) {
        this.str = str;
        this.pattern = pattern;
        ExpectsInputTypes.$init$(this);
    }
}

