/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.catalog;

import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.analysis.TempTableAlreadyExistsException;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.util.StringUtils$;
import scala.Option;
import scala.collection.Seq;
import scala.collection.mutable.HashMap;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00055a\u0001B\u0007\u000f\u0001mA\u0001B\t\u0001\u0003\u0006\u0004%\ta\t\u0005\t_\u0001\u0011\t\u0011)A\u0005I!)\u0001\u0007\u0001C\u0001c!9Q\u0007\u0001b\u0001\n\u00131\u0004BB$\u0001A\u0003%q\u0007C\u0003W\u0001\u0011\u0005q\u000bC\u0003^\u0001\u0011\u0005a\fC\u0003k\u0001\u0011\u00051\u000eC\u0003o\u0001\u0011\u0005q\u000eC\u0003r\u0001\u0011\u0005!\u000fC\u0003x\u0001\u0011\u0005\u0001\u0010C\u0004\u0002\n\u0001!\t!a\u0003\u0003+\u001dcwNY1m)\u0016l\u0007OV5fo6\u000bg.Y4fe*\u0011q\u0002E\u0001\bG\u0006$\u0018\r\\8h\u0015\t\t\"#\u0001\u0005dCR\fG._:u\u0015\t\u0019B#A\u0002tc2T!!\u0006\f\u0002\u000bM\u0004\u0018M]6\u000b\u0005]A\u0012AB1qC\u000eDWMC\u0001\u001a\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0004\u0005\u0002\u001eA5\taDC\u0001 \u0003\u0015\u00198-\u00197b\u0013\t\tcD\u0001\u0004B]f\u0014VMZ\u0001\tI\u0006$\u0018MY1tKV\tA\u0005\u0005\u0002&Y9\u0011aE\u000b\t\u0003Oyi\u0011\u0001\u000b\u0006\u0003Si\ta\u0001\u0010:p_Rt\u0014BA\u0016\u001f\u0003\u0019\u0001&/\u001a3fM&\u0011QF\f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005-r\u0012!\u00033bi\u0006\u0014\u0017m]3!\u0003\u0019a\u0014N\\5u}Q\u0011!\u0007\u000e\t\u0003g\u0001i\u0011A\u0004\u0005\u0006E\r\u0001\r\u0001J\u0001\u0010m&,w\u000fR3gS:LG/[8ogV\tq\u0007\u0005\u00039{\u0011zT\"A\u001d\u000b\u0005iZ\u0014aB7vi\u0006\u0014G.\u001a\u0006\u0003yy\t!bY8mY\u0016\u001cG/[8o\u0013\tq\u0014HA\u0004ICNDW*\u00199\u0011\u0005\u0001+U\"A!\u000b\u0005\t\u001b\u0015a\u00027pO&\u001c\u0017\r\u001c\u0006\u0003\tB\tQ\u0001\u001d7b]NL!AR!\u0003\u00171{w-[2bYBc\u0017M\\\u0001\u0011m&,w\u000fR3gS:LG/[8og\u0002BC!B%T)B\u0011!*U\u0007\u0002\u0017*\u0011A*T\u0001\u000bG>t7-\u001e:sK:$(B\u0001(P\u0003)\tgN\\8uCRLwN\u001c\u0006\u0002!\u0006)!.\u0019<bq&\u0011!k\u0013\u0002\n\u000fV\f'\u000fZ3e\u0005f\fQA^1mk\u0016\f\u0013!V\u0001\u0005i\"L7/A\u0002hKR$\"\u0001W.\u0011\u0007uIv(\u0003\u0002[=\t1q\n\u001d;j_:DQ\u0001\u0018\u0004A\u0002\u0011\nAA\\1nK\u000611M]3bi\u0016$Ba\u00182dKB\u0011Q\u0004Y\u0005\u0003Cz\u0011A!\u00168ji\")Al\u0002a\u0001I!)Am\u0002a\u0001\u007f\u0005qa/[3x\t\u00164\u0017N\\5uS>t\u0007\"\u00024\b\u0001\u00049\u0017\u0001E8wKJ\u0014\u0018\u000eZ3JM\u0016C\u0018n\u001d;t!\ti\u0002.\u0003\u0002j=\t9!i\\8mK\u0006t\u0017AB;qI\u0006$X\rF\u0002hY6DQ\u0001\u0018\u0005A\u0002\u0011BQ\u0001\u001a\u0005A\u0002}\naA]3n_Z,GCA4q\u0011\u0015a\u0016\u00021\u0001%\u0003\u0019\u0011XM\\1nKR\u0019qm];\t\u000bQT\u0001\u0019\u0001\u0013\u0002\u000f=dGMT1nK\")aO\u0003a\u0001I\u00059a.Z<OC6,\u0017!\u00047jgR4\u0016.Z<OC6,7\u000fF\u0002z\u0003\u000b\u00012A_@%\u001d\tYXP\u0004\u0002(y&\tq$\u0003\u0002\u007f=\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u0001\u0003\u0007\u00111aU3r\u0015\tqh\u0004\u0003\u0004\u0002\b-\u0001\r\u0001J\u0001\ba\u0006$H/\u001a:o\u0003\u0015\u0019G.Z1s)\u0005y\u0006")
public class GlobalTempViewManager {
    private final String database;
    @GuardedBy(value="this")
    private final HashMap<String, LogicalPlan> viewDefinitions;

    public String database() {
        return this.database;
    }

    private HashMap<String, LogicalPlan> viewDefinitions() {
        return this.viewDefinitions;
    }

    public synchronized Option<LogicalPlan> get(String name) {
        return this.viewDefinitions().get((Object)name);
    }

    public void create(String name, LogicalPlan viewDefinition, boolean overrideIfExists) {
        GlobalTempViewManager globalTempViewManager = this;
        synchronized (globalTempViewManager) {
            if (!overrideIfExists && this.viewDefinitions().contains((Object)name)) {
                throw new TempTableAlreadyExistsException(name);
            }
            this.viewDefinitions().put((Object)name, (Object)viewDefinition);
        }
    }

    public synchronized boolean update(String name, LogicalPlan viewDefinition) {
        boolean bl;
        if (this.viewDefinitions().contains((Object)name)) {
            this.viewDefinitions().put((Object)name, (Object)viewDefinition);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public synchronized boolean remove(String name) {
        return this.viewDefinitions().remove((Object)name).isDefined();
    }

    public synchronized boolean rename(String oldName, String newName) {
        boolean bl;
        if (this.viewDefinitions().contains((Object)oldName)) {
            if (this.viewDefinitions().contains((Object)newName)) {
                throw new AnalysisException(new StringBuilder(68).append("rename temporary view from '").append(oldName).append("' to '").append(newName).append("': destination view already exists").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            LogicalPlan viewDefinition = (LogicalPlan)this.viewDefinitions().apply((Object)oldName);
            this.viewDefinitions().remove((Object)oldName);
            this.viewDefinitions().put((Object)newName, (Object)viewDefinition);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public synchronized Seq<String> listViewNames(String pattern) {
        return StringUtils$.MODULE$.filterPattern((Seq<String>)this.viewDefinitions().keys().toSeq(), pattern);
    }

    public synchronized void clear() {
        this.viewDefinitions().clear();
    }

    public GlobalTempViewManager(String database) {
        this.database = database;
        this.viewDefinitions = new HashMap();
    }
}

