/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.LBSolrClient;
import org.apache.solr.client.solrj.request.AbstractUpdateRequest;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.XML;

public class UpdateRequest
extends AbstractUpdateRequest {
    public static final String REPFACT = "rf";
    public static final String VER = "ver";
    public static final String OVERWRITE = "ow";
    public static final String COMMIT_WITHIN = "cw";
    private Map<SolrInputDocument, Map<String, Object>> documents = null;
    private Iterator<SolrInputDocument> docIterator = null;
    private Map<String, Map<String, Object>> deleteById = null;
    private List<String> deleteQuery = null;
    private boolean isLastDocInBatch = false;

    public UpdateRequest() {
        super(SolrRequest.METHOD.POST, "/update");
    }

    public UpdateRequest(String url) {
        super(SolrRequest.METHOD.POST, url);
    }

    public void clear() {
        if (this.documents != null) {
            this.documents.clear();
        }
        if (this.deleteById != null) {
            this.deleteById.clear();
        }
        if (this.deleteQuery != null) {
            this.deleteQuery.clear();
        }
    }

    public UpdateRequest add(SolrInputDocument doc) {
        Objects.requireNonNull(doc, "Cannot add a null SolrInputDocument");
        if (this.documents == null) {
            this.documents = new LinkedHashMap<SolrInputDocument, Map<String, Object>>();
        }
        this.documents.put(doc, null);
        return this;
    }

    public UpdateRequest add(String ... fields) {
        return this.add(new SolrInputDocument(fields));
    }

    public UpdateRequest add(SolrInputDocument doc, Boolean overwrite) {
        return this.add(doc, null, overwrite);
    }

    public UpdateRequest add(SolrInputDocument doc, Integer commitWithin) {
        return this.add(doc, commitWithin, null);
    }

    public UpdateRequest add(SolrInputDocument doc, Integer commitWithin, Boolean overwrite) {
        Objects.requireNonNull(doc, "Cannot add a null SolrInputDocument");
        if (this.documents == null) {
            this.documents = new LinkedHashMap<SolrInputDocument, Map<String, Object>>();
        }
        HashMap<String, Constable> params = new HashMap<String, Constable>(2);
        if (commitWithin != null) {
            params.put(COMMIT_WITHIN, commitWithin);
        }
        if (overwrite != null) {
            params.put(OVERWRITE, overwrite);
        }
        this.documents.put(doc, params);
        return this;
    }

    public UpdateRequest add(Collection<SolrInputDocument> docs) {
        if (this.documents == null) {
            this.documents = new LinkedHashMap<SolrInputDocument, Map<String, Object>>();
        }
        for (SolrInputDocument doc : docs) {
            Objects.requireNonNull(doc, "Cannot add a null SolrInputDocument");
            this.documents.put(doc, null);
        }
        return this;
    }

    public UpdateRequest deleteById(String id) {
        if (this.deleteById == null) {
            this.deleteById = new LinkedHashMap<String, Map<String, Object>>();
        }
        this.deleteById.put(id, null);
        return this;
    }

    public UpdateRequest deleteById(String id, String route) {
        return this.deleteById(id, route, null);
    }

    public UpdateRequest deleteById(String id, String route, Long version) {
        HashMap<String, Object> params;
        if (this.deleteById == null) {
            this.deleteById = new LinkedHashMap<String, Map<String, Object>>();
        }
        HashMap<String, Object> hashMap = params = route == null && version == null ? null : new HashMap<String, Object>(1);
        if (version != null) {
            params.put(VER, version);
        }
        if (route != null) {
            params.put("_route_", route);
        }
        this.deleteById.put(id, params);
        return this;
    }

    public UpdateRequest deleteById(List<String> ids) {
        if (this.deleteById == null) {
            this.deleteById = new LinkedHashMap<String, Map<String, Object>>();
        }
        for (String id : ids) {
            this.deleteById.put(id, null);
        }
        return this;
    }

    public UpdateRequest deleteById(String id, Long version) {
        return this.deleteById(id, null, version);
    }

    public UpdateRequest deleteByQuery(String q) {
        if (this.deleteQuery == null) {
            this.deleteQuery = new ArrayList<String>();
        }
        this.deleteQuery.add(q);
        return this;
    }

    public UpdateRequest withRoute(String route) {
        if (this.params == null) {
            this.params = new ModifiableSolrParams();
        }
        this.params.set("_route_", route);
        return this;
    }

    public UpdateResponse commit(SolrClient client, String collection) throws IOException, SolrServerException {
        if (this.params == null) {
            this.params = new ModifiableSolrParams();
        }
        this.params.set("commit", "true");
        return (UpdateResponse)this.process(client, collection);
    }

    private <T extends LBSolrClient.Req> Map<String, T> getRoutes(DocRouter router, DocCollection col, Map<String, List<String>> urlMap, ModifiableSolrParams params, String idField, ReqSupplier<T> reqSupplier) {
        if (!(this.documents != null && this.documents.size() != 0 || this.deleteById != null && this.deleteById.size() != 0)) {
            return null;
        }
        HashMap<String, LBSolrClient.Req> routes = new HashMap<String, LBSolrClient.Req>();
        if (this.documents != null) {
            Set<Map.Entry<SolrInputDocument, Map<String, Object>>> entries = this.documents.entrySet();
            Iterator<Map.Entry<SolrInputDocument, Map<String, Object>>> iterator = entries.iterator();
            while (iterator.hasNext()) {
                Map.Entry<SolrInputDocument, Map<String, Object>> entry = iterator.next();
                SolrInputDocument doc = entry.getKey();
                Object id = doc.getFieldValue(idField);
                if (id == null) {
                    return null;
                }
                Slice slice = router.getTargetSlice(id.toString(), doc, null, null, col);
                if (slice == null) {
                    return null;
                }
                List<String> urls = urlMap.get(slice.getName());
                if (urls == null) {
                    return null;
                }
                String leaderUrl = urls.get(0);
                LBSolrClient.Req request = (LBSolrClient.Req)routes.get(leaderUrl);
                if (request == null) {
                    UpdateRequest updateRequest = new UpdateRequest();
                    updateRequest.setMethod(this.getMethod());
                    updateRequest.setCommitWithin(this.getCommitWithin());
                    updateRequest.setParams(params);
                    updateRequest.setPath(this.getPath());
                    updateRequest.setBasicAuthCredentials(this.getBasicAuthUser(), this.getBasicAuthPassword());
                    updateRequest.setResponseParser(this.getResponseParser());
                    request = reqSupplier.get(updateRequest, urls);
                    routes.put(leaderUrl, request);
                }
                UpdateRequest urequest = (UpdateRequest)request.getRequest();
                Map<String, Object> value = entry.getValue();
                Boolean ow = null;
                if (value != null) {
                    ow = (Boolean)value.get(OVERWRITE);
                }
                if (ow != null) {
                    urequest.add(doc, ow);
                    continue;
                }
                urequest.add(doc);
            }
        }
        if (this.deleteById != null) {
            for (Map.Entry entry : this.deleteById.entrySet()) {
                UpdateRequest urequest;
                Slice slice;
                String deleteId = (String)entry.getKey();
                Map map = (Map)entry.getValue();
                Long version = null;
                String route = null;
                if (map != null) {
                    version = (Long)map.get(VER);
                    route = (String)map.get("_route_");
                }
                if ((slice = router.getTargetSlice(deleteId, null, route, null, col)) == null) {
                    return null;
                }
                List<String> urls = urlMap.get(slice.getName());
                if (urls == null) {
                    return null;
                }
                String leaderUrl = urls.get(0);
                LBSolrClient.Req request = (LBSolrClient.Req)routes.get(leaderUrl);
                if (request != null) {
                    urequest = (UpdateRequest)request.getRequest();
                    urequest.deleteById(deleteId, route, version);
                    continue;
                }
                urequest = new UpdateRequest();
                urequest.setParams(params);
                urequest.deleteById(deleteId, route, version);
                urequest.setCommitWithin(this.getCommitWithin());
                urequest.setBasicAuthCredentials(this.getBasicAuthUser(), this.getBasicAuthPassword());
                request = reqSupplier.get(urequest, urls);
                routes.put(leaderUrl, request);
            }
        }
        return routes;
    }

    public Map<String, LBSolrClient.Req> getRoutesToCollection(DocRouter router, DocCollection col, Map<String, List<String>> urlMap, ModifiableSolrParams params, String idField) {
        return this.getRoutes(router, col, urlMap, params, idField, LBSolrClient.Req::new);
    }

    public void setDocIterator(Iterator<SolrInputDocument> docIterator) {
        this.docIterator = docIterator;
    }

    public void setDeleteQuery(List<String> deleteQuery) {
        this.deleteQuery = deleteQuery;
    }

    @Override
    public Collection<ContentStream> getContentStreams() throws IOException {
        return ClientUtils.toContentStreams(this.getXML(), "application/xml; charset=UTF-8");
    }

    public String getXML() throws IOException {
        StringWriter writer = new StringWriter();
        this.writeXML(writer);
        writer.flush();
        String xml = writer.toString();
        return xml.length() > 0 ? xml : null;
    }

    private List<Map<SolrInputDocument, Map<String, Object>>> getDocLists(Map<SolrInputDocument, Map<String, Object>> documents) {
        ArrayList<Map<SolrInputDocument, Map<String, Object>>> docLists = new ArrayList<Map<SolrInputDocument, Map<String, Object>>>();
        LinkedHashMap<SolrInputDocument, Map<String, Object>> docList = null;
        if (this.documents != null) {
            Boolean lastOverwrite = true;
            Integer lastCommitWithin = -1;
            Set<Map.Entry<SolrInputDocument, Map<String, Object>>> entries = this.documents.entrySet();
            for (Map.Entry<SolrInputDocument, Map<String, Object>> entry : entries) {
                Map<String, Object> map = entry.getValue();
                Boolean overwrite = null;
                Integer commitWithin = null;
                if (map != null) {
                    overwrite = (Boolean)entry.getValue().get(OVERWRITE);
                    commitWithin = (Integer)entry.getValue().get(COMMIT_WITHIN);
                }
                if (!Objects.equals(overwrite, lastOverwrite) || !Objects.equals(commitWithin, lastCommitWithin) || docLists.isEmpty()) {
                    docList = new LinkedHashMap();
                    docLists.add(docList);
                }
                docList.put(entry.getKey(), entry.getValue());
                lastCommitWithin = commitWithin;
                lastOverwrite = overwrite;
            }
        }
        if (this.docIterator != null) {
            docList = new LinkedHashMap<SolrInputDocument, Map<String, Object>>();
            docLists.add(docList);
            while (this.docIterator.hasNext()) {
                SolrInputDocument doc = this.docIterator.next();
                if (doc == null) continue;
                docList.put(doc, null);
            }
        }
        return docLists;
    }

    public UpdateRequest writeXML(Writer writer) throws IOException {
        boolean deleteQ;
        List<Map<SolrInputDocument, Map<String, Object>>> getDocLists = this.getDocLists(this.documents);
        for (Map<SolrInputDocument, Map<String, Object>> docs : getDocLists) {
            if (docs == null || docs.size() <= 0) continue;
            Map.Entry<SolrInputDocument, Map<String, Object>> firstDoc = docs.entrySet().iterator().next();
            Map<String, Object> map = firstDoc.getValue();
            Integer cw = null;
            Boolean ow = null;
            if (map != null) {
                cw = (Integer)firstDoc.getValue().get(COMMIT_WITHIN);
                ow = (Boolean)firstDoc.getValue().get(OVERWRITE);
            }
            if (ow == null) {
                ow = true;
            }
            int commitWithin = cw != null && cw != -1 ? cw : this.commitWithin;
            boolean overwrite = ow;
            if (commitWithin > -1 || !overwrite) {
                writer.write("<add commitWithin=\"" + commitWithin + "\" overwrite=\"" + overwrite + "\">");
            } else {
                writer.write("<add>");
            }
            Set<Map.Entry<SolrInputDocument, Map<String, Object>>> entries = docs.entrySet();
            for (Map.Entry<SolrInputDocument, Map<String, Object>> entry : entries) {
                ClientUtils.writeXML(entry.getKey(), writer);
            }
            writer.write("</add>");
        }
        boolean deleteI = this.deleteById != null && this.deleteById.size() > 0;
        boolean bl = deleteQ = this.deleteQuery != null && this.deleteQuery.size() > 0;
        if (deleteI || deleteQ) {
            if (this.commitWithin > 0) {
                writer.append("<delete commitWithin=\"").append(String.valueOf(this.commitWithin)).append("\">");
            } else {
                writer.append("<delete>");
            }
            if (deleteI) {
                for (Map.Entry entry : this.deleteById.entrySet()) {
                    writer.append("<id");
                    Map map = (Map)entry.getValue();
                    if (map != null) {
                        Long version = (Long)map.get(VER);
                        String route = (String)map.get("_route_");
                        if (version != null) {
                            writer.append(" version=\"").append(String.valueOf(version)).append('\"');
                        }
                        if (route != null) {
                            writer.append(" _route_=\"").append(route).append('\"');
                        }
                    }
                    writer.append(">");
                    XML.escapeCharData((String)entry.getKey(), writer);
                    writer.append("</id>");
                }
            }
            if (deleteQ) {
                for (String string : this.deleteQuery) {
                    writer.append("<query>");
                    XML.escapeCharData(string, writer);
                    writer.append("</query>");
                }
            }
            writer.append("</delete>");
        }
        return this;
    }

    public List<SolrInputDocument> getDocuments() {
        if (this.documents == null) {
            return null;
        }
        ArrayList<SolrInputDocument> docs = new ArrayList<SolrInputDocument>(this.documents.size());
        docs.addAll(this.documents.keySet());
        return docs;
    }

    public Map<SolrInputDocument, Map<String, Object>> getDocumentsMap() {
        return this.documents;
    }

    public Iterator<SolrInputDocument> getDocIterator() {
        return this.docIterator;
    }

    public List<String> getDeleteById() {
        if (this.deleteById == null) {
            return null;
        }
        ArrayList<String> deletes = new ArrayList<String>(this.deleteById.keySet());
        return deletes;
    }

    public Map<String, Map<String, Object>> getDeleteByIdMap() {
        return this.deleteById;
    }

    public List<String> getDeleteQuery() {
        return this.deleteQuery;
    }

    public boolean isLastDocInBatch() {
        return this.isLastDocInBatch;
    }

    public void lastDocInBatch() {
        this.isLastDocInBatch = true;
    }

    private static interface ReqSupplier<T extends LBSolrClient.Req> {
        public T get(UpdateRequest var1, List<String> var2);
    }
}

