/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.network.trace.component.command;

import java.util.ArrayList;
import java.util.List;
import org.apache.skywalking.apm.network.common.v3.Command;
import org.apache.skywalking.apm.network.common.v3.KeyStringValuePair;
import org.apache.skywalking.apm.network.trace.component.command.BaseCommand;
import org.apache.skywalking.apm.network.trace.component.command.Deserializable;
import org.apache.skywalking.apm.network.trace.component.command.Serializable;

public class ConfigurationDiscoveryCommand
extends BaseCommand
implements Serializable,
Deserializable<ConfigurationDiscoveryCommand> {
    public static final Deserializable<ConfigurationDiscoveryCommand> DESERIALIZER = new ConfigurationDiscoveryCommand("", "", new ArrayList<KeyStringValuePair>());
    public static final String NAME = "ConfigurationDiscoveryCommand";
    public static final String UUID_CONST_NAME = "UUID";
    public static final String SERIAL_NUMBER_CONST_NAME = "SerialNumber";
    private String uuid;
    private List<KeyStringValuePair> config;

    public ConfigurationDiscoveryCommand(String serialNumber, String uuid, List<KeyStringValuePair> config) {
        super(NAME, serialNumber);
        this.uuid = uuid;
        this.config = config;
    }

    @Override
    public ConfigurationDiscoveryCommand deserialize(Command command) {
        String serialNumber = null;
        String uuid = null;
        ArrayList<KeyStringValuePair> config = new ArrayList<KeyStringValuePair>();
        for (KeyStringValuePair pair : command.getArgsList()) {
            if (SERIAL_NUMBER_CONST_NAME.equals(pair.getKey())) {
                serialNumber = pair.getValue();
                continue;
            }
            if (UUID_CONST_NAME.equals(pair.getKey())) {
                uuid = pair.getValue();
                continue;
            }
            config.add(pair);
        }
        return new ConfigurationDiscoveryCommand(serialNumber, uuid, config);
    }

    @Override
    public Command.Builder serialize() {
        Command.Builder builder = this.commandBuilder();
        builder.addArgs(KeyStringValuePair.newBuilder().setKey(UUID_CONST_NAME).setValue(this.uuid));
        builder.addAllArgs(this.config);
        return builder;
    }

    public String getUuid() {
        return this.uuid;
    }

    public List<KeyStringValuePair> getConfig() {
        return this.config;
    }

    public String toString() {
        return "ConfigurationDiscoveryCommand{uuid='" + this.uuid + '\'' + ", config=" + this.config + '}';
    }
}

