/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.remote;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.skywalking.apm.agent.core.boot.BootService;
import org.apache.skywalking.apm.agent.core.boot.DefaultImplementor;
import org.apache.skywalking.apm.agent.core.boot.ServiceManager;
import org.apache.skywalking.apm.agent.core.commands.CommandService;
import org.apache.skywalking.apm.agent.core.conf.Config;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.agent.core.remote.GRPCChannelListener;
import org.apache.skywalking.apm.agent.core.remote.GRPCChannelManager;
import org.apache.skywalking.apm.agent.core.remote.GRPCChannelStatus;
import org.apache.skywalking.apm.dependencies.io.grpc.Channel;
import org.apache.skywalking.apm.dependencies.io.grpc.stub.StreamObserver;
import org.apache.skywalking.apm.network.common.v3.Commands;
import org.apache.skywalking.apm.network.event.v3.Event;
import org.apache.skywalking.apm.network.event.v3.EventServiceGrpc;
import org.apache.skywalking.apm.network.event.v3.Source;
import org.apache.skywalking.apm.network.event.v3.Type;

@DefaultImplementor
public class EventReportServiceClient
implements BootService,
GRPCChannelListener {
    private static final ILog LOGGER = LogManager.getLogger(EventReportServiceClient.class);
    private final AtomicBoolean reported = new AtomicBoolean();
    private Event.Builder startingEvent;
    private EventServiceGrpc.EventServiceStub eventServiceStub;
    private GRPCChannelStatus status;

    @Override
    public void prepare() throws Throwable {
        ServiceManager.INSTANCE.findService(GRPCChannelManager.class).addChannelListener(this);
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        this.startingEvent = Event.newBuilder().setUuid(UUID.randomUUID().toString()).setName("Start").setStartTime(runtimeMxBean.getStartTime()).setMessage("Start Java Application").setType(Type.Normal).setSource(Source.newBuilder().setService(Config.Agent.SERVICE_NAME).setServiceInstance(Config.Agent.INSTANCE_NAME).build()).putParameters("OPTS", runtimeMxBean.getInputArguments().stream().sorted().collect(Collectors.joining(" ")));
    }

    @Override
    public void boot() throws Throwable {
    }

    @Override
    public void onComplete() throws Throwable {
        this.startingEvent.setEndTime(System.currentTimeMillis());
        this.reportStartingEvent();
    }

    @Override
    public void shutdown() throws Throwable {
        if (!GRPCChannelStatus.CONNECTED.equals((Object)this.status)) {
            return;
        }
        final CountDownLatch latch = new CountDownLatch(1);
        Event.Builder shutdownEvent = Event.newBuilder().setUuid(UUID.randomUUID().toString()).setName("Shutdown").setStartTime(System.currentTimeMillis()).setEndTime(System.currentTimeMillis()).setMessage("Shutting down Java Application").setType(Type.Normal).setSource(Source.newBuilder().setService(Config.Agent.SERVICE_NAME).setServiceInstance(Config.Agent.INSTANCE_NAME).build());
        StreamObserver<Event> collector = this.eventServiceStub.collect(new StreamObserver<Commands>(){

            @Override
            public void onNext(Commands commands) {
                ServiceManager.INSTANCE.findService(CommandService.class).receiveCommand(commands);
            }

            @Override
            public void onError(Throwable t) {
                LOGGER.error("Failed to report shutdown event.", t);
                latch.countDown();
            }

            @Override
            public void onCompleted() {
                latch.countDown();
            }
        });
        collector.onNext(shutdownEvent.build());
        collector.onCompleted();
        latch.await();
    }

    @Override
    public void statusChanged(GRPCChannelStatus status) {
        this.status = status;
        if (!GRPCChannelStatus.CONNECTED.equals((Object)status)) {
            return;
        }
        Channel channel = ServiceManager.INSTANCE.findService(GRPCChannelManager.class).getChannel();
        this.eventServiceStub = EventServiceGrpc.newStub(channel);
        this.eventServiceStub = (EventServiceGrpc.EventServiceStub)this.eventServiceStub.withDeadlineAfter(Config.Collector.GRPC_UPSTREAM_TIMEOUT, TimeUnit.SECONDS);
        this.reportStartingEvent();
    }

    private void reportStartingEvent() {
        if (this.reported.compareAndSet(false, true)) {
            return;
        }
        StreamObserver<Event> collector = this.eventServiceStub.collect(new StreamObserver<Commands>(){

            @Override
            public void onNext(Commands commands) {
                ServiceManager.INSTANCE.findService(CommandService.class).receiveCommand(commands);
            }

            @Override
            public void onError(Throwable t) {
                LOGGER.error("Failed to report starting event.", t);
                ServiceManager.INSTANCE.findService(GRPCChannelManager.class).reportError(t);
                EventReportServiceClient.this.reported.set(false);
            }

            @Override
            public void onCompleted() {
            }
        });
        collector.onNext(this.startingEvent.build());
        collector.onCompleted();
    }
}

