/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.profile;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.skywalking.apm.agent.core.boot.BootService;
import org.apache.skywalking.apm.agent.core.boot.DefaultImplementor;
import org.apache.skywalking.apm.agent.core.boot.ServiceManager;
import org.apache.skywalking.apm.agent.core.conf.Config;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.agent.core.profile.TracingThreadSnapshot;
import org.apache.skywalking.apm.agent.core.remote.GRPCChannelListener;
import org.apache.skywalking.apm.agent.core.remote.GRPCChannelManager;
import org.apache.skywalking.apm.agent.core.remote.GRPCChannelStatus;
import org.apache.skywalking.apm.agent.core.remote.GRPCStreamServiceStatus;
import org.apache.skywalking.apm.dependencies.io.grpc.Channel;
import org.apache.skywalking.apm.dependencies.io.grpc.stub.StreamObserver;
import org.apache.skywalking.apm.network.common.v3.Commands;
import org.apache.skywalking.apm.network.language.profile.v3.ProfileTaskGrpc;
import org.apache.skywalking.apm.network.language.profile.v3.ThreadSnapshot;

@DefaultImplementor
public class ProfileSnapshotSender
implements BootService,
GRPCChannelListener {
    private static final ILog LOGGER = LogManager.getLogger(ProfileSnapshotSender.class);
    private volatile GRPCChannelStatus status = GRPCChannelStatus.DISCONNECT;
    private volatile ProfileTaskGrpc.ProfileTaskStub profileTaskStub;

    @Override
    public void prepare() throws Throwable {
        ServiceManager.INSTANCE.findService(GRPCChannelManager.class).addChannelListener(this);
    }

    @Override
    public void boot() throws Throwable {
    }

    @Override
    public void statusChanged(GRPCChannelStatus status) {
        if (GRPCChannelStatus.CONNECTED.equals((Object)status)) {
            Channel channel = ServiceManager.INSTANCE.findService(GRPCChannelManager.class).getChannel();
            this.profileTaskStub = ProfileTaskGrpc.newStub(channel);
        } else {
            this.profileTaskStub = null;
        }
        this.status = status;
    }

    public void send(List<TracingThreadSnapshot> buffer) {
        if (this.status == GRPCChannelStatus.CONNECTED) {
            try {
                final GRPCStreamServiceStatus status = new GRPCStreamServiceStatus(false);
                StreamObserver<ThreadSnapshot> snapshotStreamObserver = ((ProfileTaskGrpc.ProfileTaskStub)this.profileTaskStub.withDeadlineAfter(Config.Collector.GRPC_UPSTREAM_TIMEOUT, TimeUnit.SECONDS)).collectSnapshot(new StreamObserver<Commands>(){

                    @Override
                    public void onNext(Commands commands) {
                    }

                    @Override
                    public void onError(Throwable throwable) {
                        status.finished();
                        if (LOGGER.isErrorEnable()) {
                            LOGGER.error(throwable, "Send profile segment snapshot to collector fail with a grpc internal exception.", new Object[0]);
                        }
                        ServiceManager.INSTANCE.findService(GRPCChannelManager.class).reportError(throwable);
                    }

                    @Override
                    public void onCompleted() {
                        status.finished();
                    }
                });
                for (TracingThreadSnapshot snapshot : buffer) {
                    ThreadSnapshot transformSnapshot = snapshot.transform();
                    snapshotStreamObserver.onNext(transformSnapshot);
                }
                snapshotStreamObserver.onCompleted();
                status.wait4Finish();
            }
            catch (Throwable t) {
                LOGGER.error(t, "Send profile segment snapshot to backend fail.", new Object[0]);
            }
        }
    }

    @Override
    public void onComplete() throws Throwable {
    }

    @Override
    public void shutdown() throws Throwable {
    }
}

