/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.distsql.handler.update;

import java.util.Collections;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.config.scope.SchemaRuleConfiguration;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.distsql.exception.rule.RequiredAlgorithmMissedException;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionDropUpdater;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.shadow.api.config.ShadowRuleConfiguration;
import org.apache.shardingsphere.shadow.distsql.handler.checker.ShadowRuleStatementChecker;
import org.apache.shardingsphere.shadow.distsql.parser.statement.DropDefaultShadowAlgorithmStatement;

public final class DropDefaultShadowAlgorithmStatementUpdater
implements RuleDefinitionDropUpdater<DropDefaultShadowAlgorithmStatement, ShadowRuleConfiguration> {
    private static final String SHADOW = "shadow";

    public void checkSQLStatement(ShardingSphereDatabase database, DropDefaultShadowAlgorithmStatement sqlStatement, ShadowRuleConfiguration currentRuleConfig) throws DistSQLException {
        if (sqlStatement.isContainsExistClause() && !this.isExistRuleConfig((RuleConfiguration)currentRuleConfig)) {
            return;
        }
        this.checkConfigurationExist(database.getName(), (SchemaRuleConfiguration)currentRuleConfig);
        this.checkAlgorithm(database.getName(), sqlStatement, currentRuleConfig);
    }

    private void checkConfigurationExist(String databaseName, SchemaRuleConfiguration currentRuleConfig) throws DistSQLException {
        ShadowRuleStatementChecker.checkConfigurationExist(databaseName, currentRuleConfig);
    }

    private void checkAlgorithm(String databaseName, DropDefaultShadowAlgorithmStatement sqlStatement, ShadowRuleConfiguration currentRuleConfig) throws DistSQLException {
        if (!sqlStatement.isContainsExistClause()) {
            DistSQLException.predictionThrow((null != currentRuleConfig.getDefaultShadowAlgorithmName() ? 1 : 0) != 0, () -> new RequiredAlgorithmMissedException(SHADOW, databaseName, Collections.singleton("default")));
        }
    }

    public boolean hasAnyOneToBeDropped(DropDefaultShadowAlgorithmStatement sqlStatement, ShadowRuleConfiguration currentRuleConfig) {
        return null != currentRuleConfig && null != currentRuleConfig.getDefaultShadowAlgorithmName();
    }

    public boolean updateCurrentRuleConfiguration(DropDefaultShadowAlgorithmStatement sqlStatement, ShadowRuleConfiguration currentRuleConfig) {
        currentRuleConfig.setDefaultShadowAlgorithmName(null);
        return false;
    }

    public Class<ShadowRuleConfiguration> getRuleConfigurationClass() {
        return ShadowRuleConfiguration.class;
    }

    public String getType() {
        return DropDefaultShadowAlgorithmStatement.class.getName();
    }
}

