/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.distsql.handler.update;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.distsql.exception.rule.DuplicateRuleException;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionCreateUpdater;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.shadow.api.config.ShadowRuleConfiguration;
import org.apache.shardingsphere.shadow.api.config.table.ShadowTableConfiguration;
import org.apache.shardingsphere.shadow.distsql.handler.checker.ShadowRuleStatementChecker;
import org.apache.shardingsphere.shadow.distsql.handler.converter.ShadowRuleStatementConverter;
import org.apache.shardingsphere.shadow.distsql.handler.supporter.ShadowRuleStatementSupporter;
import org.apache.shardingsphere.shadow.distsql.parser.segment.ShadowAlgorithmSegment;
import org.apache.shardingsphere.shadow.distsql.parser.segment.ShadowRuleSegment;
import org.apache.shardingsphere.shadow.distsql.parser.statement.CreateShadowRuleStatement;

public final class CreateShadowRuleStatementUpdater
implements RuleDefinitionCreateUpdater<CreateShadowRuleStatement, ShadowRuleConfiguration> {
    private static final String SHADOW = "shadow";

    public RuleConfiguration buildToBeCreatedRuleConfiguration(CreateShadowRuleStatement sqlStatement) {
        return ShadowRuleStatementConverter.convert(sqlStatement.getRules());
    }

    public void updateCurrentRuleConfiguration(ShadowRuleConfiguration currentRuleConfig, ShadowRuleConfiguration toBeCreatedRuleConfig) {
        if (null != currentRuleConfig) {
            currentRuleConfig.getDataSources().putAll(toBeCreatedRuleConfig.getDataSources());
            currentRuleConfig.getShadowAlgorithms().putAll(toBeCreatedRuleConfig.getShadowAlgorithms());
            this.updateTables(currentRuleConfig.getTables(), toBeCreatedRuleConfig.getTables());
        }
    }

    private void updateTables(Map<String, ShadowTableConfiguration> currentTables, Map<String, ShadowTableConfiguration> toBeCreateTables) {
        toBeCreateTables.forEach((key, value) -> currentTables.merge((String)key, (ShadowTableConfiguration)value, ShadowRuleStatementSupporter::mergeConfiguration));
    }

    public void checkSQLStatement(ShardingSphereDatabase database, CreateShadowRuleStatement sqlStatement, ShadowRuleConfiguration currentRuleConfig) throws DistSQLException {
        String databaseName = database.getName();
        Collection rules = sqlStatement.getRules();
        this.checkRuleNames(databaseName, rules, currentRuleConfig);
        this.checkResources(database, rules);
        this.checkAlgorithms(databaseName, rules, currentRuleConfig);
    }

    private void checkRuleNames(String databaseName, Collection<ShadowRuleSegment> rules, ShadowRuleConfiguration currentRuleConfig) throws DistSQLException {
        List<String> requireRuleNames = ShadowRuleStatementSupporter.getRuleNames(rules);
        ShadowRuleStatementChecker.checkAnyDuplicate(requireRuleNames, duplicated -> new DuplicateRuleException(SHADOW, databaseName, duplicated));
        List<String> currentRuleName = ShadowRuleStatementSupporter.getRuleNames(currentRuleConfig);
        ShadowRuleStatementChecker.checkAnyDuplicate(requireRuleNames, currentRuleName, identical -> new DuplicateRuleException(SHADOW, databaseName, identical));
    }

    private void checkResources(ShardingSphereDatabase database, Collection<ShadowRuleSegment> rules) throws DistSQLException {
        List<String> requireResource = ShadowRuleStatementSupporter.getResourceNames(rules);
        ShadowRuleStatementChecker.checkResourceExist(requireResource, database);
    }

    private void checkAlgorithms(String databaseName, Collection<ShadowRuleSegment> rules, ShadowRuleConfiguration currentRuleConfig) throws DistSQLException {
        List<ShadowAlgorithmSegment> requireAlgorithms = ShadowRuleStatementSupporter.getShadowAlgorithmSegment(rules);
        ShadowRuleStatementChecker.checkAlgorithmCompleteness(requireAlgorithms);
        List<String> requireAlgorithmNames = ShadowRuleStatementSupporter.getAlgorithmNames(rules);
        ShadowRuleStatementChecker.checkAnyDuplicate(requireAlgorithmNames, duplicated -> new DuplicateRuleException(SHADOW, databaseName, duplicated));
        List<String> currentAlgorithmNames = ShadowRuleStatementSupporter.getAlgorithmNames(currentRuleConfig);
        ShadowRuleStatementChecker.checkAnyDuplicate(requireAlgorithmNames, currentAlgorithmNames, duplicated -> new DuplicateRuleException(SHADOW, databaseName, duplicated));
    }

    public Class<ShadowRuleConfiguration> getRuleConfigurationClass() {
        return ShadowRuleConfiguration.class;
    }

    public String getType() {
        return CreateShadowRuleStatement.class.getName();
    }
}

