/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.distsql.handler.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.infra.distsql.query.DistSQLResultSet;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.shadow.api.config.ShadowRuleConfiguration;
import org.apache.shardingsphere.shadow.distsql.parser.statement.ShowShadowTableRulesStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class ShadowTableRuleQueryResultSet
implements DistSQLResultSet {
    private static final String SHADOW_TABLE = "shadow_table";
    private static final String SHADOW_ALGORITHM_NAME = "shadow_algorithm_name";
    private Iterator<Map<String, String>> data = Collections.emptyIterator();

    public void init(ShardingSphereDatabase database, SQLStatement sqlStatement) {
        Optional<ShadowRuleConfiguration> ruleConfig = database.getRuleMetaData().getConfigurations().stream().filter(each -> each instanceof ShadowRuleConfiguration).map(each -> (ShadowRuleConfiguration)each).findAny();
        ruleConfig.ifPresent(optional -> {
            this.data = this.buildData((ShadowRuleConfiguration)optional).iterator();
        });
    }

    private List<Map<String, String>> buildData(ShadowRuleConfiguration shadowRuleConfiguration) {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        shadowRuleConfiguration.getTables().forEach((key, value) -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(SHADOW_TABLE, (String)key);
            map.put(SHADOW_ALGORITHM_NAME, this.convertToString(value.getShadowAlgorithmNames()));
            result.add(map);
        });
        return result;
    }

    public Collection<String> getColumnNames() {
        return Arrays.asList(SHADOW_TABLE, SHADOW_ALGORITHM_NAME);
    }

    public boolean next() {
        return this.data.hasNext();
    }

    public Collection<Object> getRowData() {
        return this.buildTableRowData(this.data.next());
    }

    private Collection<Object> buildTableRowData(Map<String, String> data) {
        return Arrays.asList(data.get(SHADOW_TABLE), data.get(SHADOW_ALGORITHM_NAME));
    }

    private String convertToString(Collection<String> shadowTables) {
        if (null != shadowTables) {
            return String.join((CharSequence)",", shadowTables);
        }
        return "";
    }

    public String getType() {
        return ShowShadowTableRulesStatement.class.getName();
    }
}

