/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.underlying.route.hook;

import java.util.Collection;
import org.apache.shardingsphere.spi.NewInstanceServiceLoader;
import org.apache.shardingsphere.sql.parser.binder.metadata.schema.SchemaMetaData;
import org.apache.shardingsphere.underlying.route.context.RouteContext;
import org.apache.shardingsphere.underlying.route.hook.RoutingHook;

public final class SPIRoutingHook
implements RoutingHook {
    private final Collection<RoutingHook> routingHooks = NewInstanceServiceLoader.newServiceInstances(RoutingHook.class);

    @Override
    public void start(String sql) {
        for (RoutingHook each : this.routingHooks) {
            each.start(sql);
        }
    }

    @Override
    public void finishSuccess(RouteContext routeContext, SchemaMetaData schemaMetaData) {
        for (RoutingHook each : this.routingHooks) {
            each.finishSuccess(routeContext, schemaMetaData);
        }
    }

    @Override
    public void finishFailure(Exception cause) {
        for (RoutingHook each : this.routingHooks) {
            each.finishFailure(cause);
        }
    }

    static {
        NewInstanceServiceLoader.register(RoutingHook.class);
    }
}

