/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.util.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Objects;
import lombok.Generated;

public final class ReflectiveUtil {
    public static Object getFieldValue(Object target, String fieldName) {
        Field field = ReflectiveUtil.getField(target.getClass(), fieldName);
        Objects.requireNonNull(field).setAccessible(true);
        return field.get(target);
    }

    private static Field getField(Class<?> target, String fieldName) {
        for (Class<?> clazz = target; null != clazz; clazz = clazz.getSuperclass()) {
            try {
                return clazz.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        return null;
    }

    public static void setField(Object target, String fieldName, Object value) {
        Field field = ReflectiveUtil.getField(target.getClass(), fieldName);
        Objects.requireNonNull(field).setAccessible(true);
        field.set(target, value);
    }

    public static void setStaticField(Class<?> target, String fieldName, Object value) {
        Field field = ReflectiveUtil.getField(target, fieldName);
        if (Modifier.isStatic(Objects.requireNonNull(field).getModifiers())) {
            field.setAccessible(true);
            field.set(null, value);
        }
    }

    @Generated
    private ReflectiveUtil() {
    }
}

