/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.optimize.converter.segment.from;

import java.util.Optional;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOrderBy;
import org.apache.calcite.sql.SqlSelect;
import org.apache.shardingsphere.infra.optimize.converter.segment.SQLSegmentConverter;
import org.apache.shardingsphere.infra.optimize.converter.segment.from.impl.JoinTableConverter;
import org.apache.shardingsphere.infra.optimize.converter.segment.from.impl.SimpleTableConverter;
import org.apache.shardingsphere.infra.optimize.converter.segment.from.impl.SubqueryTableConverter;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.JoinTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SubqueryTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.TableSegment;

public final class TableConverter
implements SQLSegmentConverter<TableSegment, SqlNode> {
    @Override
    public Optional<SqlNode> convertToSQLNode(TableSegment segment) {
        if (segment instanceof SimpleTableSegment) {
            return new SimpleTableConverter().convertToSQLNode((SimpleTableSegment)segment);
        }
        if (segment instanceof JoinTableSegment) {
            return new JoinTableConverter().convertToSQLNode((JoinTableSegment)segment).map(optional -> optional);
        }
        if (segment instanceof SubqueryTableSegment) {
            return new SubqueryTableConverter().convertToSQLNode((SubqueryTableSegment)segment).map(optional -> optional);
        }
        throw new UnsupportedOperationException("Unsupported segment type: " + segment.getClass());
    }

    @Override
    public Optional<TableSegment> convertToSQLSegment(SqlNode sqlNode) {
        if (sqlNode instanceof SqlIdentifier) {
            return new SimpleTableConverter().convertToSQLSegment(sqlNode).map(optional -> optional);
        }
        if (sqlNode instanceof SqlJoin) {
            return new JoinTableConverter().convertToSQLSegment((SqlJoin)sqlNode).map(optional -> optional);
        }
        if (sqlNode instanceof SqlBasicCall) {
            Optional<SqlNode> existSubquery = ((SqlBasicCall)sqlNode).getOperandList().stream().filter(this::containsSqlSelect).findAny();
            if (existSubquery.isPresent()) {
                return new SubqueryTableConverter().convertToSQLSegment((SqlBasicCall)sqlNode).map(optional -> optional);
            }
            return new SimpleTableConverter().convertToSQLSegment(sqlNode).map(optional -> optional);
        }
        throw new UnsupportedOperationException("Unsupported sql node type: " + sqlNode.getClass());
    }

    private boolean containsSqlSelect(SqlNode sqlNode) {
        return sqlNode instanceof SqlSelect || sqlNode instanceof SqlOrderBy;
    }
}

