/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.optimize.converter.segment.expression.impl;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.shardingsphere.infra.optimize.converter.segment.SQLSegmentConverter;
import org.apache.shardingsphere.infra.optimize.converter.segment.expression.ExpressionConverter;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;

public final class BinaryOperationExpressionConverter
implements SQLSegmentConverter<BinaryOperationExpression, SqlBasicCall> {
    private static final Map<String, SqlBinaryOperator> REGISTRY = new TreeMap<String, SqlBinaryOperator>(String.CASE_INSENSITIVE_ORDER);

    private static void register(SqlBinaryOperator sqlBinaryOperator) {
        REGISTRY.put(sqlBinaryOperator.getName(), sqlBinaryOperator);
    }

    @Override
    public Optional<SqlBasicCall> convertToSQLNode(BinaryOperationExpression segment) {
        SqlBinaryOperator operator = this.convertOperator(segment.getOperator());
        SqlNode left = new ExpressionConverter().convertToSQLNode(segment.getLeft()).orElseThrow(IllegalStateException::new);
        SqlNode right = new ExpressionConverter().convertToSQLNode(segment.getRight()).orElseThrow(IllegalStateException::new);
        return Optional.of(new SqlBasicCall((SqlOperator)operator, new SqlNode[]{left, right}, SqlParserPos.ZERO));
    }

    @Override
    public Optional<BinaryOperationExpression> convertToSQLSegment(SqlBasicCall sqlBasicCall) {
        ExpressionConverter expressionConverter = new ExpressionConverter();
        ExpressionSegment left = expressionConverter.convertToSQLSegment((SqlNode)sqlBasicCall.getOperandList().get(0)).orElseThrow(IllegalStateException::new);
        ExpressionSegment right = expressionConverter.convertToSQLSegment((SqlNode)sqlBasicCall.getOperandList().get(1)).orElseThrow(IllegalStateException::new);
        String operator = sqlBasicCall.getOperator().getName();
        String text = sqlBasicCall.toString();
        return Optional.of(new BinaryOperationExpression(this.getStartIndex((SqlNode)sqlBasicCall), this.getStopIndex((SqlNode)sqlBasicCall), left, right, operator, text));
    }

    private SqlBinaryOperator convertOperator(String operator) {
        Preconditions.checkState((boolean)REGISTRY.containsKey(operator), (String)"Unsupported SQL operator: `%s`", (Object)operator);
        return REGISTRY.get(operator);
    }

    static {
        BinaryOperationExpressionConverter.register(SqlStdOperatorTable.EQUALS);
        BinaryOperationExpressionConverter.register(SqlStdOperatorTable.NOT_EQUALS);
        BinaryOperationExpressionConverter.register(SqlStdOperatorTable.GREATER_THAN);
        BinaryOperationExpressionConverter.register(SqlStdOperatorTable.GREATER_THAN_OR_EQUAL);
        BinaryOperationExpressionConverter.register(SqlStdOperatorTable.LESS_THAN);
        BinaryOperationExpressionConverter.register(SqlStdOperatorTable.LESS_THAN_OR_EQUAL);
        BinaryOperationExpressionConverter.register(SqlStdOperatorTable.OR);
        BinaryOperationExpressionConverter.register(SqlStdOperatorTable.AND);
        BinaryOperationExpressionConverter.register(SqlStdOperatorTable.PLUS);
        BinaryOperationExpressionConverter.register(SqlStdOperatorTable.MINUS);
        BinaryOperationExpressionConverter.register(SqlStdOperatorTable.MULTIPLY);
        BinaryOperationExpressionConverter.register(SqlStdOperatorTable.DIVIDE);
    }
}

