/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.federation.optimizer.metadata.translatable;

import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.shardingsphere.infra.federation.optimizer.metadata.translatable.TranslatableTableScan;

public class TranslatableProjectRule
extends RelOptRule {
    public static final TranslatableProjectRule INSTANCE = new TranslatableProjectRule(RelFactories.LOGICAL_BUILDER);

    public TranslatableProjectRule(RelBuilderFactory relBuilderFactory) {
        super(TranslatableProjectRule.operand(LogicalProject.class, (RelOptRuleOperand)TranslatableProjectRule.operand(TranslatableTableScan.class, (RelOptRuleOperandChildren)TranslatableProjectRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), relBuilderFactory, "TranslatableProjectRule");
    }

    public void onMatch(RelOptRuleCall call) {
        LogicalProject project = (LogicalProject)call.rel(0);
        TranslatableTableScan scan = (TranslatableTableScan)call.rel(1);
        int[] fields = this.getProjectFields(project.getProjects());
        if (fields == null) {
            return;
        }
        call.transformTo((RelNode)new TranslatableTableScan(scan.getCluster(), scan.getTable(), scan.getTranslatableTable(), scan.getFilters(), fields));
    }

    private int[] getProjectFields(List<RexNode> rexNodes) {
        int[] result = new int[rexNodes.size()];
        for (int index = 0; index < rexNodes.size(); ++index) {
            RexNode exp = rexNodes.get(index);
            if (!(exp instanceof RexInputRef)) {
                return null;
            }
            result[index] = ((RexInputRef)exp).getIndex();
        }
        return result;
    }
}

