/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.federation.optimizer.metadata.filter;

import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.shardingsphere.infra.federation.optimizer.executor.TableScanExecutor;
import org.apache.shardingsphere.infra.federation.optimizer.metadata.filter.FilterableTable;
import org.apache.shardingsphere.infra.federation.optimizer.metadata.statistic.FederationStatistic;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereTable;

public final class FilterableSchema
extends AbstractSchema {
    private final String name;
    private final Map<String, Table> tableMap;

    public FilterableSchema(String schemaName, ShardingSphereSchema schema, TableScanExecutor executor) {
        this.name = schemaName;
        this.tableMap = this.createTableMap(schema, executor);
    }

    private Map<String, Table> createTableMap(ShardingSphereSchema schema, TableScanExecutor executor) {
        LinkedHashMap<String, Table> result = new LinkedHashMap<String, Table>(schema.getTables().size(), 1.0f);
        for (ShardingSphereTable each : schema.getTables().values()) {
            result.put(each.getName(), (Table)new FilterableTable(each, executor, new FederationStatistic()));
        }
        return result;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Map<String, Table> getTableMap() {
        return this.tableMap;
    }
}

