/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.federation.optimizer.converter.segment.projection;

import java.util.LinkedList;
import java.util.Optional;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.shardingsphere.infra.federation.optimizer.converter.segment.SQLSegmentConverter;
import org.apache.shardingsphere.infra.federation.optimizer.converter.segment.projection.impl.AggregationProjectionConverter;
import org.apache.shardingsphere.infra.federation.optimizer.converter.segment.projection.impl.ColumnProjectionConverter;
import org.apache.shardingsphere.infra.federation.optimizer.converter.segment.projection.impl.ExpressionProjectionConverter;
import org.apache.shardingsphere.infra.federation.optimizer.converter.segment.projection.impl.ShorthandProjectionConverter;
import org.apache.shardingsphere.infra.federation.optimizer.converter.segment.projection.impl.SubqueryProjectionConverter;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.AggregationProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ColumnProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ExpressionProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionsSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ShorthandProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.SubqueryProjectionSegment;

public final class ProjectionsConverter
implements SQLSegmentConverter<ProjectionsSegment, SqlNodeList> {
    @Override
    public Optional<SqlNodeList> convert(ProjectionsSegment segment) {
        LinkedList projectionSQLNodes = new LinkedList();
        for (ProjectionSegment each : segment.getProjections()) {
            this.getProjectionSQLNode(each).ifPresent(projectionSQLNodes::add);
        }
        return Optional.of(new SqlNodeList(projectionSQLNodes, SqlParserPos.ZERO));
    }

    private Optional<SqlNode> getProjectionSQLNode(ProjectionSegment segment) {
        if (segment instanceof ColumnProjectionSegment) {
            return new ColumnProjectionConverter().convert((ColumnProjectionSegment)segment);
        }
        if (segment instanceof ExpressionProjectionSegment) {
            return new ExpressionProjectionConverter().convert((ExpressionProjectionSegment)segment);
        }
        if (segment instanceof ShorthandProjectionSegment) {
            return new ShorthandProjectionConverter().convert((ShorthandProjectionSegment)segment).map(optional -> optional);
        }
        if (segment instanceof SubqueryProjectionSegment) {
            return new SubqueryProjectionConverter().convert((SubqueryProjectionSegment)segment);
        }
        if (segment instanceof AggregationProjectionSegment) {
            return new AggregationProjectionConverter().convert((AggregationProjectionSegment)segment).map(optional -> optional);
        }
        return Optional.empty();
    }
}

