/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.federation.optimizer.converter.segment.limit;

import java.util.Optional;
import lombok.Generated;
import org.apache.calcite.sql.SqlDynamicParam;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.shardingsphere.infra.federation.optimizer.converter.context.ConverterContext;
import org.apache.shardingsphere.infra.federation.optimizer.converter.segment.SQLSegmentConverter;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.pagination.NumberLiteralPaginationValueSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.pagination.PaginationValueSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.pagination.limit.NumberLiteralLimitValueSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.pagination.limit.ParameterMarkerLimitValueSegment;

public final class PaginationValueSQLConverter
implements SQLSegmentConverter<PaginationValueSegment, SqlNode> {
    private final ConverterContext context;

    @Override
    public Optional<SqlNode> convertToSQLNode(PaginationValueSegment segment) {
        return Optional.of(segment instanceof NumberLiteralPaginationValueSegment ? this.getLiteralSQLNode((NumberLiteralPaginationValueSegment)segment) : this.getParameterMarkerSQLNode((ParameterMarkerLimitValueSegment)segment));
    }

    private SqlNode getLiteralSQLNode(NumberLiteralPaginationValueSegment segment) {
        return SqlLiteral.createExactNumeric((String)String.valueOf(segment.getValue()), (SqlParserPos)SqlParserPos.ZERO);
    }

    private SqlNode getParameterMarkerSQLNode(ParameterMarkerLimitValueSegment segment) {
        return new SqlDynamicParam(segment.getParameterIndex(), SqlParserPos.ZERO);
    }

    @Override
    public Optional<PaginationValueSegment> convertToSQLSegment(SqlNode sqlNode) {
        if (sqlNode instanceof SqlNumericLiteral) {
            return Optional.of(new NumberLiteralLimitValueSegment(this.getStartIndex(sqlNode), this.getStopIndex(sqlNode), ((Long)((SqlNumericLiteral)sqlNode).getValueAs(Long.class)).longValue()));
        }
        if (sqlNode instanceof SqlDynamicParam) {
            this.context.getParameterCount().incrementAndGet();
            return Optional.of(new ParameterMarkerLimitValueSegment(this.getStartIndex(sqlNode), this.getStopIndex(sqlNode), ((SqlDynamicParam)sqlNode).getIndex()));
        }
        return Optional.empty();
    }

    @Generated
    public PaginationValueSQLConverter(ConverterContext context) {
        this.context = context;
    }
}

