/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.federation.optimizer.converter.segment.from.impl;

import java.util.Optional;
import org.apache.calcite.sql.JoinConditionType;
import org.apache.calcite.sql.JoinType;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.shardingsphere.infra.federation.optimizer.converter.segment.SQLSegmentConverter;
import org.apache.shardingsphere.infra.federation.optimizer.converter.segment.expression.ExpressionConverter;
import org.apache.shardingsphere.infra.federation.optimizer.converter.segment.from.TableConverter;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.JoinTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.TableSegment;

public final class JoinTableConverter
implements SQLSegmentConverter<JoinTableSegment, SqlJoin> {
    private static final String JOIN_TYPE_INNER = "INNER";
    private static final String JOIN_TYPE_LEFT = "LEFT";
    private static final String JOIN_TYPE_RIGHT = "RIGHT";
    private static final String JOIN_TYPE_FULL = "FULL";

    @Override
    public Optional<SqlJoin> convertToSQLNode(JoinTableSegment segment) {
        SqlNode left = new TableConverter().convertToSQLNode(segment.getLeft()).orElseThrow(IllegalStateException::new);
        SqlNode right = new TableConverter().convertToSQLNode(segment.getRight()).orElseThrow(IllegalStateException::new);
        Optional<SqlNode> condition = new ExpressionConverter().convertToSQLNode(segment.getCondition());
        SqlLiteral conditionType = condition.isPresent() ? JoinConditionType.ON.symbol(SqlParserPos.ZERO) : JoinConditionType.NONE.symbol(SqlParserPos.ZERO);
        return Optional.of(new SqlJoin(SqlParserPos.ZERO, left, SqlLiteral.createBoolean((boolean)false, (SqlParserPos)SqlParserPos.ZERO), this.convertJoinType(segment.getJoinType()), right, conditionType, (SqlNode)condition.orElse(null)));
    }

    @Override
    public Optional<JoinTableSegment> convertToSQLSegment(SqlJoin sqlJoin) {
        TableSegment left = new TableConverter().convertToSQLSegment(sqlJoin.getLeft()).orElseThrow(IllegalStateException::new);
        TableSegment right = new TableConverter().convertToSQLSegment(sqlJoin.getRight()).orElseThrow(IllegalStateException::new);
        JoinTableSegment result = new JoinTableSegment();
        result.setStartIndex(this.getStartIndex((SqlNode)sqlJoin));
        result.setStartIndex(this.getStopIndex((SqlNode)sqlJoin));
        result.setLeft(left);
        result.setRight(right);
        new ExpressionConverter().convertToSQLSegment(sqlJoin.getCondition()).ifPresent(arg_0 -> ((JoinTableSegment)result).setCondition(arg_0));
        return Optional.of(result);
    }

    private SqlLiteral convertJoinType(String joinType) {
        if (null == joinType) {
            return JoinType.COMMA.symbol(SqlParserPos.ZERO);
        }
        if (JOIN_TYPE_INNER.equals(joinType)) {
            return JoinType.INNER.symbol(SqlParserPos.ZERO);
        }
        if (JOIN_TYPE_LEFT.equals(joinType)) {
            return JoinType.LEFT.symbol(SqlParserPos.ZERO);
        }
        if (JOIN_TYPE_RIGHT.equals(joinType)) {
            return JoinType.RIGHT.symbol(SqlParserPos.ZERO);
        }
        if (JOIN_TYPE_FULL.equals(joinType)) {
            return JoinType.FULL.symbol(SqlParserPos.ZERO);
        }
        throw new UnsupportedOperationException("unsupported join type " + joinType);
    }
}

