/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.federation.optimizer.converter.segment.expression.impl;

import java.util.Optional;
import org.apache.calcite.sql.SqlNode;
import org.apache.shardingsphere.infra.federation.optimizer.converter.segment.SQLSegmentConverter;
import org.apache.shardingsphere.infra.federation.optimizer.converter.statement.SelectStatementConverter;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.subquery.SubqueryExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.subquery.SubquerySegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;

public final class SubqueryExpressionConverter
implements SQLSegmentConverter<SubqueryExpressionSegment, SqlNode> {
    @Override
    public Optional<SqlNode> convertToSQLNode(SubqueryExpressionSegment expression) {
        if (null == expression) {
            return Optional.empty();
        }
        return Optional.of(new SelectStatementConverter().convertToSQLNode(expression.getSubquery().getSelect()));
    }

    @Override
    public Optional<SubqueryExpressionSegment> convertToSQLSegment(SqlNode sqlNode) {
        if (null == sqlNode) {
            return Optional.empty();
        }
        SelectStatement selectStatement = new SelectStatementConverter().convertToSQLStatement(sqlNode);
        int startIndex = this.getStartIndex(sqlNode) - 1;
        int stopIndex = this.getStopIndex(sqlNode) + 1;
        return Optional.of(new SubqueryExpressionSegment(new SubquerySegment(startIndex, stopIndex, selectStatement)));
    }
}

