/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.sql.process;

import com.google.common.base.Strings;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.QueryContext;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupContext;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutorDataMap;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.SQLExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.process.model.ExecuteProcessConstants;
import org.apache.shardingsphere.infra.executor.sql.process.spi.ExecuteProcessReporter;
import org.apache.shardingsphere.infra.executor.sql.process.spi.ExecuteProcessReporterFactory;
import org.apache.shardingsphere.infra.metadata.user.Grantee;
import org.apache.shardingsphere.infra.util.eventbus.EventBusContext;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.DDLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.DMLStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.MySQLStatement;

public final class ExecuteProcessEngine {
    public static String initializeConnection(Grantee grantee, String databaseName, EventBusContext eventBusContext) {
        ExecutionGroupContext executionGroupContext = new ExecutionGroupContext(Collections.emptyList());
        executionGroupContext.setExecutionID(new UUID(ThreadLocalRandom.current().nextLong(), ThreadLocalRandom.current().nextLong()).toString().replace("-", ""));
        executionGroupContext.setGrantee(grantee);
        executionGroupContext.setDatabaseName(databaseName);
        Optional<ExecuteProcessReporter> reporter = ExecuteProcessReporterFactory.getInstance();
        reporter.ifPresent(executeProcessReporter -> executeProcessReporter.report(executionGroupContext));
        return executionGroupContext.getExecutionID();
    }

    public static void finishConnection(String executionID) {
        Optional<ExecuteProcessReporter> reporter = ExecuteProcessReporterFactory.getInstance();
        reporter.ifPresent(executeProcessReporter -> executeProcessReporter.reportRemove(executionID));
    }

    public static void initializeExecution(QueryContext queryContext, ExecutionGroupContext<? extends SQLExecutionUnit> executionGroupContext, EventBusContext eventBusContext) {
        Optional<ExecuteProcessReporter> reporter = ExecuteProcessReporterFactory.getInstance();
        if (Strings.isNullOrEmpty((String)executionGroupContext.getExecutionID())) {
            executionGroupContext.setExecutionID(new UUID(ThreadLocalRandom.current().nextLong(), ThreadLocalRandom.current().nextLong()).toString().replace("-", ""));
        }
        if (reporter.isPresent() && ExecuteProcessEngine.isMySQLDDLOrDMLStatement(queryContext.getSqlStatementContext().getSqlStatement())) {
            ExecutorDataMap.getValue().put(ExecuteProcessConstants.EXECUTE_ID.name(), executionGroupContext.getExecutionID());
            reporter.get().report(queryContext, executionGroupContext, ExecuteProcessConstants.EXECUTE_STATUS_START, eventBusContext);
        }
    }

    public static void finishExecution(String executionID, SQLExecutionUnit executionUnit, EventBusContext eventBusContext) {
        Optional<ExecuteProcessReporter> reporter = ExecuteProcessReporterFactory.getInstance();
        if (reporter.isPresent() && ExecutorDataMap.getValue().containsKey(ExecuteProcessConstants.EXECUTE_ID.name())) {
            reporter.get().report(executionID, executionUnit, ExecuteProcessConstants.EXECUTE_STATUS_DONE, eventBusContext);
        }
    }

    public static void finishExecution(String executionID, EventBusContext eventBusContext) {
        Optional<ExecuteProcessReporter> reporter = ExecuteProcessReporterFactory.getInstance();
        if (reporter.isPresent() && ExecutorDataMap.getValue().containsKey(ExecuteProcessConstants.EXECUTE_ID.name())) {
            reporter.get().report(executionID, ExecuteProcessConstants.EXECUTE_STATUS_DONE, eventBusContext);
        }
    }

    public static void cleanExecution() {
        Optional<ExecuteProcessReporter> reporter = ExecuteProcessReporterFactory.getInstance();
        if (reporter.isPresent() && ExecutorDataMap.getValue().containsKey(ExecuteProcessConstants.EXECUTE_ID.name())) {
            reporter.get().reportClean(ExecutorDataMap.getValue().get(ExecuteProcessConstants.EXECUTE_ID.name()).toString());
        }
        ExecutorDataMap.getValue().remove(ExecuteProcessConstants.EXECUTE_ID.name());
    }

    private static boolean isMySQLDDLOrDMLStatement(SQLStatement sqlStatement) {
        return sqlStatement instanceof MySQLStatement && (sqlStatement instanceof DDLStatement || sqlStatement instanceof DMLStatement);
    }

    @Generated
    private ExecuteProcessEngine() {
    }
}

