/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.context.refresher.type;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.context.refresher.MetaDataRefresher;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.builder.GenericSchemaBuilder;
import org.apache.shardingsphere.infra.metadata.database.schema.builder.GenericSchemaBuilderMaterials;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.database.schema.event.MetaDataRefreshedEvent;
import org.apache.shardingsphere.infra.metadata.database.schema.event.SchemaAlteredEvent;
import org.apache.shardingsphere.infra.rule.identifier.type.DataNodeContainedRule;
import org.apache.shardingsphere.infra.rule.identifier.type.MutableDataNodeRule;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.AlterViewStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.ddl.AlterViewStatementHandler;

public final class AlterViewStatementSchemaRefresher
implements MetaDataRefresher<AlterViewStatement> {
    @Override
    public Optional<MetaDataRefreshedEvent> refresh(ShardingSphereDatabase database, Collection<String> logicDataSourceNames, String schemaName, AlterViewStatement sqlStatement, ConfigurationProperties props) throws SQLException {
        String viewName = sqlStatement.getView().getTableName().getIdentifier().getValue();
        SchemaAlteredEvent event = new SchemaAlteredEvent(database.getName(), schemaName);
        Optional renameView = AlterViewStatementHandler.getRenameView((AlterViewStatement)sqlStatement);
        if (renameView.isPresent()) {
            String renameViewName = ((SimpleTableSegment)renameView.get()).getTableName().getIdentifier().getValue();
            this.putTableMetaData(database, logicDataSourceNames, schemaName, renameViewName, props);
            this.removeTableMetaData(database, schemaName, viewName);
            event.getAlteredTables().add(database.getSchema(schemaName).get(renameViewName));
            event.getDroppedTables().add(viewName);
        } else {
            this.putTableMetaData(database, logicDataSourceNames, schemaName, viewName, props);
            event.getAlteredTables().add(database.getSchema(schemaName).get(viewName));
        }
        return Optional.of(event);
    }

    private void removeTableMetaData(ShardingSphereDatabase database, String schemaName, String viewName) {
        database.getSchema(schemaName).remove(viewName);
        database.getRuleMetaData().findRules(MutableDataNodeRule.class).forEach(each -> each.remove(schemaName, viewName));
    }

    private void putTableMetaData(ShardingSphereDatabase database, Collection<String> logicDataSourceNames, String schemaName, String viewName, ConfigurationProperties props) throws SQLException {
        if (!this.containsInImmutableDataNodeContainedRule(viewName, database)) {
            database.getRuleMetaData().findRules(MutableDataNodeRule.class).forEach(each -> each.put((String)logicDataSourceNames.iterator().next(), schemaName, viewName));
        }
        GenericSchemaBuilderMaterials materials = new GenericSchemaBuilderMaterials(database.getProtocolType(), database.getResource().getDatabaseType(), database.getResource().getDataSources(), database.getRuleMetaData().getRules(), props, schemaName);
        Map schemaMap = GenericSchemaBuilder.build(Collections.singletonList(viewName), (GenericSchemaBuilderMaterials)materials);
        Optional<ShardingSphereTable> actualViewMetaData = Optional.ofNullable(schemaMap.get(schemaName)).map(optional -> optional.get(viewName));
        actualViewMetaData.ifPresent(optional -> database.getSchema(schemaName).put(viewName, optional));
    }

    private boolean containsInImmutableDataNodeContainedRule(String viewName, ShardingSphereDatabase database) {
        return database.getRuleMetaData().findRules(DataNodeContainedRule.class).stream().filter(each -> !(each instanceof MutableDataNodeRule)).anyMatch(each -> each.getAllTables().contains(viewName));
    }

    public String getType() {
        return AlterViewStatement.class.getName();
    }
}

