/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.context.refresher;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.MetaDataRefresher;
import org.apache.shardingsphere.infra.metadata.schema.refresher.type.AlterIndexStatementSchemaRefresher;
import org.apache.shardingsphere.infra.metadata.schema.refresher.type.AlterTableStatementSchemaRefresher;
import org.apache.shardingsphere.infra.metadata.schema.refresher.type.CreateIndexStatementSchemaRefresher;
import org.apache.shardingsphere.infra.metadata.schema.refresher.type.CreateTableStatementSchemaRefresher;
import org.apache.shardingsphere.infra.metadata.schema.refresher.type.CreateViewStatementSchemaRefresher;
import org.apache.shardingsphere.infra.metadata.schema.refresher.type.DropIndexStatementSchemaRefresher;
import org.apache.shardingsphere.infra.metadata.schema.refresher.type.DropTableStatementSchemaRefresher;
import org.apache.shardingsphere.infra.metadata.schema.refresher.type.DropViewStatementSchemaRefresher;
import org.apache.shardingsphere.infra.optimize.metadata.refresher.type.AlterTableFederationMetaDataRefresher;
import org.apache.shardingsphere.infra.optimize.metadata.refresher.type.CreateTableFederationMetaDataRefresher;
import org.apache.shardingsphere.infra.optimize.metadata.refresher.type.DropTableFederationMetaDataRefresher;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.AlterIndexStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.AlterTableStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.CreateIndexStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.CreateTableStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.CreateViewStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.DropIndexStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.DropTableStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.DropViewStatement;

public final class MetaDataRefresherFactory {
    private static final Map<Class<?>, Collection<MetaDataRefresher>> REGISTRY = new HashMap();

    public static Collection<MetaDataRefresher> newInstance(SQLStatement sqlStatement) {
        for (Map.Entry<Class<?>, Collection<MetaDataRefresher>> entry : REGISTRY.entrySet()) {
            if (!entry.getKey().isAssignableFrom(sqlStatement.getClass())) continue;
            return entry.getValue();
        }
        return Collections.emptyList();
    }

    @Generated
    private MetaDataRefresherFactory() {
    }

    static {
        REGISTRY.put(CreateTableStatement.class, new LinkedHashSet());
        REGISTRY.put(AlterTableStatement.class, new LinkedHashSet());
        REGISTRY.put(DropTableStatement.class, new LinkedHashSet());
        REGISTRY.put(CreateIndexStatement.class, new LinkedHashSet());
        REGISTRY.put(AlterIndexStatement.class, new LinkedHashSet());
        REGISTRY.put(DropIndexStatement.class, new LinkedHashSet());
        REGISTRY.put(CreateViewStatement.class, new LinkedHashSet());
        REGISTRY.put(DropViewStatement.class, new LinkedHashSet());
        REGISTRY.get(CreateTableStatement.class).add((MetaDataRefresher)new CreateTableStatementSchemaRefresher());
        REGISTRY.get(CreateTableStatement.class).add((MetaDataRefresher)new CreateTableFederationMetaDataRefresher());
        REGISTRY.get(AlterTableStatement.class).add((MetaDataRefresher)new AlterTableStatementSchemaRefresher());
        REGISTRY.get(AlterTableStatement.class).add((MetaDataRefresher)new AlterTableFederationMetaDataRefresher());
        REGISTRY.get(DropTableStatement.class).add((MetaDataRefresher)new DropTableStatementSchemaRefresher());
        REGISTRY.get(DropTableStatement.class).add((MetaDataRefresher)new DropTableFederationMetaDataRefresher());
        REGISTRY.get(CreateIndexStatement.class).add((MetaDataRefresher)new CreateIndexStatementSchemaRefresher());
        REGISTRY.get(AlterIndexStatement.class).add((MetaDataRefresher)new AlterIndexStatementSchemaRefresher());
        REGISTRY.get(DropIndexStatement.class).add((MetaDataRefresher)new DropIndexStatementSchemaRefresher());
        REGISTRY.get(CreateViewStatement.class).add((MetaDataRefresher)new CreateViewStatementSchemaRefresher());
        REGISTRY.get(DropViewStatement.class).add((MetaDataRefresher)new DropViewStatementSchemaRefresher());
    }
}

