/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database.resource;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.metadata.DataSourceMetaData;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.datasource.pool.destroyer.DataSourcePoolDestroyer;
import org.apache.shardingsphere.infra.datasource.props.DataSourcePropertiesCreator;
import org.apache.shardingsphere.infra.datasource.state.DataSourceStateManager;

public final class ShardingSphereResourceMetaData {
    private final Map<String, DataSource> dataSources;
    private final Map<String, DatabaseType> storageTypes;
    private final Map<String, DataSourceMetaData> dataSourceMetaDataMap;

    public ShardingSphereResourceMetaData(String databaseName, Map<String, DataSource> dataSources) {
        this.dataSources = dataSources;
        Map<String, DataSource> enabledDataSources = DataSourceStateManager.getInstance().getEnabledDataSourceMap(databaseName, dataSources);
        this.storageTypes = this.createStorageTypes(enabledDataSources);
        this.dataSourceMetaDataMap = this.createDataSourceMetaDataMap(enabledDataSources, this.storageTypes);
    }

    public ShardingSphereResourceMetaData(Map<String, DataSource> dataSources) {
        this.dataSources = dataSources;
        this.storageTypes = DatabaseTypeEngine.getStorageTypes(dataSources);
        this.dataSourceMetaDataMap = this.createDataSourceMetaDataMap(dataSources, this.storageTypes);
    }

    private Map<String, DatabaseType> createStorageTypes(Map<String, DataSource> enabledDataSources) {
        LinkedHashMap<String, DatabaseType> result = new LinkedHashMap<String, DatabaseType>(this.dataSources.size(), 1.0f);
        for (Map.Entry<String, DataSource> entry : this.dataSources.entrySet()) {
            DatabaseType storageType = enabledDataSources.containsKey(entry.getKey()) ? DatabaseTypeEngine.getStorageType(Collections.singletonList(entry.getValue())) : DatabaseTypeEngine.getStorageType(Collections.emptyList());
            result.put(entry.getKey(), storageType);
        }
        return result;
    }

    private Map<String, DataSourceMetaData> createDataSourceMetaDataMap(Map<String, DataSource> dataSources, Map<String, DatabaseType> storageTypes) {
        LinkedHashMap<String, DataSourceMetaData> result = new LinkedHashMap<String, DataSourceMetaData>(dataSources.size(), 1.0f);
        for (Map.Entry<String, DataSource> entry : dataSources.entrySet()) {
            Map<String, Object> standardProps = DataSourcePropertiesCreator.create(entry.getValue()).getConnectionPropertySynonyms().getStandardProperties();
            DatabaseType storageType = storageTypes.get(entry.getKey());
            result.put(entry.getKey(), storageType.getDataSourceMetaData(standardProps.get("url").toString(), standardProps.get("username").toString()));
        }
        return result;
    }

    public Collection<String> getAllInstanceDataSourceNames() {
        LinkedList<String> result = new LinkedList<String>();
        for (Map.Entry<String, DataSourceMetaData> entry : this.dataSourceMetaDataMap.entrySet()) {
            if (this.isExisted(entry.getKey(), result)) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    private boolean isExisted(String dataSourceName, Collection<String> existedDataSourceNames) {
        return existedDataSourceNames.stream().anyMatch(each -> this.dataSourceMetaDataMap.get(dataSourceName).isInSameDatabaseInstance(this.dataSourceMetaDataMap.get(each)));
    }

    public DataSourceMetaData getDataSourceMetaData(String dataSourceName) {
        return this.dataSourceMetaDataMap.get(dataSourceName);
    }

    public DatabaseType getStorageType(String dataSourceName) {
        return this.storageTypes.get(dataSourceName);
    }

    public Collection<String> getNotExistedDataSources(Collection<String> resourceNames) {
        return resourceNames.stream().filter(each -> !this.dataSources.containsKey(each)).collect(Collectors.toSet());
    }

    public void close(DataSource dataSource) {
        new DataSourcePoolDestroyer(dataSource).asyncDestroy();
    }

    @Generated
    public Map<String, DataSource> getDataSources() {
        return this.dataSources;
    }

    @Generated
    public Map<String, DatabaseType> getStorageTypes() {
        return this.storageTypes;
    }
}

