/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.props.temporary.TemporaryConfigurationProperties;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.resource.ShardingSphereResourceMetaData;
import org.apache.shardingsphere.infra.metadata.database.rule.ShardingSphereRuleMetaData;
import org.apache.shardingsphere.infra.rule.identifier.type.ResourceHeldRule;
import org.apache.shardingsphere.infra.rule.identifier.type.StaticDataSourceContainedRule;

public final class ShardingSphereMetaData {
    private final Map<String, ShardingSphereDatabase> databases;
    private final ShardingSphereResourceMetaData globalResourceMetaData;
    private final ShardingSphereRuleMetaData globalRuleMetaData;
    private final ConfigurationProperties props;
    private final TemporaryConfigurationProperties temporaryProps;

    public ShardingSphereMetaData() {
        this(new LinkedHashMap<String, ShardingSphereDatabase>(), new ShardingSphereResourceMetaData(Collections.emptyMap()), new ShardingSphereRuleMetaData(Collections.emptyList()), new ConfigurationProperties(new Properties()));
    }

    public ShardingSphereMetaData(Map<String, ShardingSphereDatabase> databases, ShardingSphereResourceMetaData globalResourceMetaData, ShardingSphereRuleMetaData globalRuleMetaData, ConfigurationProperties props) {
        this.databases = new ConcurrentHashMap<String, ShardingSphereDatabase>(databases.size(), 1.0f);
        databases.forEach((key, value) -> this.databases.put(key.toLowerCase(), (ShardingSphereDatabase)value));
        this.globalResourceMetaData = globalResourceMetaData;
        this.globalRuleMetaData = globalRuleMetaData;
        this.props = props;
        this.temporaryProps = new TemporaryConfigurationProperties(props.getProps());
    }

    public void addDatabase(String databaseName, DatabaseType protocolType, ConfigurationProperties props) {
        ShardingSphereDatabase database = ShardingSphereDatabase.create(databaseName, protocolType, props);
        this.putDatabase(database);
        this.globalRuleMetaData.findRules(ResourceHeldRule.class).forEach(each -> each.addResource(database));
    }

    public boolean containsDatabase(String databaseName) {
        return this.databases.containsKey(databaseName.toLowerCase());
    }

    public ShardingSphereDatabase getDatabase(String databaseName) {
        return this.databases.get(databaseName.toLowerCase());
    }

    public void putDatabase(ShardingSphereDatabase database) {
        this.databases.put(database.getName().toLowerCase(), database);
    }

    public void dropDatabase(String databaseName) {
        ShardingSphereDatabase toBeRemovedDatabase = this.databases.remove(databaseName.toLowerCase());
        this.closeResources(toBeRemovedDatabase);
    }

    private void closeResources(ShardingSphereDatabase database) {
        String databaseName = database.getName();
        this.globalRuleMetaData.findRules(ResourceHeldRule.class).forEach(each -> each.closeStaleResource(databaseName));
        database.getRuleMetaData().findRules(ResourceHeldRule.class).forEach(each -> each.closeStaleResource(databaseName));
        database.getRuleMetaData().findSingleRule(StaticDataSourceContainedRule.class).ifPresent(StaticDataSourceContainedRule::cleanStorageNodeDataSources);
        Optional.ofNullable(database.getResourceMetaData()).ifPresent(optional -> optional.getDataSources().values().forEach(each -> database.getResourceMetaData().close((DataSource)each)));
    }

    @Generated
    public Map<String, ShardingSphereDatabase> getDatabases() {
        return this.databases;
    }

    @Generated
    public ShardingSphereResourceMetaData getGlobalResourceMetaData() {
        return this.globalResourceMetaData;
    }

    @Generated
    public ShardingSphereRuleMetaData getGlobalRuleMetaData() {
        return this.globalRuleMetaData;
    }

    @Generated
    public ConfigurationProperties getProps() {
        return this.props;
    }

    @Generated
    public TemporaryConfigurationProperties getTemporaryProps() {
        return this.temporaryProps;
    }
}

