/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.database.metadata.dialect;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.metadata.DataSourceMetaData;
import org.apache.shardingsphere.infra.database.metadata.UnrecognizedDatabaseURLException;

public final class OracleDataSourceMetaData
implements DataSourceMetaData {
    private static final int DEFAULT_PORT = 1521;
    private static final int THIN_MATCH_GROUP_COUNT = 5;
    private static final Pattern THIN_URL_PATTERN = Pattern.compile("jdbc:oracle:(thin|oci|kprb):@(//)?([\\w\\-\\.]+):?(\\d*)[:/]([\\w\\-]+)", 2);
    private static final Pattern CONNECT_DESCRIPTOR_URL_PATTERN = Pattern.compile("jdbc:oracle:(thin|oci|kprb):@[(\\w\\s=)]+HOST\\s*=\\s*([\\w\\-\\.]+).*PORT\\s*=\\s*(\\d+).*SERVICE_NAME\\s*=\\s*(\\w+)\\)");
    private final String hostname;
    private final int port;
    private final String catalog;
    private final String schema;

    public OracleDataSourceMetaData(String url, String username) {
        List<Matcher> matcherList = Arrays.asList(THIN_URL_PATTERN.matcher(url), CONNECT_DESCRIPTOR_URL_PATTERN.matcher(url));
        Optional<Matcher> matcherOptional = matcherList.stream().filter(Matcher::find).findAny();
        if (!matcherOptional.isPresent()) {
            throw new UnrecognizedDatabaseURLException(url, THIN_URL_PATTERN.pattern());
        }
        Matcher matcher = matcherOptional.get();
        int groupCount = matcher.groupCount();
        if (5 == groupCount) {
            this.hostname = matcher.group(3);
            this.port = Strings.isNullOrEmpty((String)matcher.group(4)) ? 1521 : Integer.parseInt(matcher.group(4));
            this.catalog = matcher.group(5);
        } else {
            this.hostname = matcher.group(2);
            this.port = Strings.isNullOrEmpty((String)matcher.group(3)) ? 1521 : Integer.parseInt(matcher.group(3));
            this.catalog = matcher.group(4);
        }
        this.schema = username;
    }

    @Override
    public Properties getQueryProperties() {
        return new Properties();
    }

    @Override
    public Properties getDefaultQueryProperties() {
        return new Properties();
    }

    @Override
    @Generated
    public String getHostname() {
        return this.hostname;
    }

    @Override
    @Generated
    public int getPort() {
        return this.port;
    }

    @Override
    @Generated
    public String getCatalog() {
        return this.catalog;
    }

    @Override
    @Generated
    public String getSchema() {
        return this.schema;
    }
}

