/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.database.metadata.dialect;

import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.metadata.DataSourceMetaData;
import org.apache.shardingsphere.infra.database.metadata.url.JdbcUrl;
import org.apache.shardingsphere.infra.database.metadata.url.StandardJdbcUrlParser;

public final class MySQLDataSourceMetaData
implements DataSourceMetaData {
    private static final int DEFAULT_PORT = 3306;
    private final String hostname;
    private final int port;
    private final String catalog;
    private final String schema;
    private final Properties queryProperties;
    private final Properties defaultQueryProperties = new Properties();

    public MySQLDataSourceMetaData(String url) {
        JdbcUrl jdbcUrl = new StandardJdbcUrlParser().parse(url);
        this.hostname = jdbcUrl.getHostname();
        this.port = -1 == jdbcUrl.getPort() ? 3306 : jdbcUrl.getPort();
        this.catalog = jdbcUrl.getDatabase();
        this.schema = null;
        this.queryProperties = jdbcUrl.getQueryProperties();
        this.buildDefaultQueryProperties();
    }

    private void buildDefaultQueryProperties() {
        this.defaultQueryProperties.setProperty("useServerPrepStmts", Boolean.TRUE.toString());
        this.defaultQueryProperties.setProperty("cachePrepStmts", Boolean.TRUE.toString());
        this.defaultQueryProperties.setProperty("prepStmtCacheSize", "8192");
        this.defaultQueryProperties.setProperty("prepStmtCacheSqlLimit", "2048");
        this.defaultQueryProperties.setProperty("useLocalSessionState", Boolean.TRUE.toString());
        this.defaultQueryProperties.setProperty("rewriteBatchedStatements", Boolean.TRUE.toString());
        this.defaultQueryProperties.setProperty("cacheResultSetMetadata", Boolean.FALSE.toString());
        this.defaultQueryProperties.setProperty("cacheServerConfiguration", Boolean.TRUE.toString());
        this.defaultQueryProperties.setProperty("elideSetAutoCommits", Boolean.TRUE.toString());
        this.defaultQueryProperties.setProperty("maintainTimeStats", Boolean.FALSE.toString());
        this.defaultQueryProperties.setProperty("netTimeoutForStreamingResults", "0");
        this.defaultQueryProperties.setProperty("tinyInt1isBit", Boolean.FALSE.toString());
        this.defaultQueryProperties.setProperty("useSSL", Boolean.FALSE.toString());
        this.defaultQueryProperties.setProperty("serverTimezone", "UTC");
        this.defaultQueryProperties.setProperty("zeroDateTimeBehavior", "round");
    }

    @Override
    @Generated
    public String getHostname() {
        return this.hostname;
    }

    @Override
    @Generated
    public int getPort() {
        return this.port;
    }

    @Override
    @Generated
    public String getCatalog() {
        return this.catalog;
    }

    @Override
    @Generated
    public String getSchema() {
        return this.schema;
    }

    @Override
    @Generated
    public Properties getQueryProperties() {
        return this.queryProperties;
    }

    @Override
    @Generated
    public Properties getDefaultQueryProperties() {
        return this.defaultQueryProperties;
    }
}

