/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.database.metadata.dialect;

import java.util.Objects;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.metadata.DataSourceMetaData;
import org.apache.shardingsphere.infra.database.metadata.UnrecognizedDatabaseURLException;

public final class H2DataSourceMetaData
implements DataSourceMetaData {
    private static final int DEFAULT_PORT = -1;
    private static final String DEFAULT_HOST_NAME = "";
    private static final String DEFAULT_H2_MODEL = "";
    private static final String MODEL_MEM = "mem";
    private static final String MODEL_PWD = "~";
    private static final String MODEL_FILE = "file:";
    private static final Pattern URL_PATTERN = Pattern.compile("jdbc:h2:((?<modelMem>mem|~)[:/](?<catalog>[\\w\\-]+)|(?<modelSslOrTcp>ssl:|tcp:)(//)?(?<hostname>[\\w\\-.]+)(:(?<port>\\d{1,4})/)?[/~\\w\\-.]+/(?<name>[\\-\\w]*)|(?<modelFile>file:)[/~\\w\\-]+/(?<fileName>[\\-\\w]*));?\\S*", 2);
    private final String hostname;
    private final String model;
    private final int port;
    private final String catalog;
    private final String schema;

    public H2DataSourceMetaData(String url) {
        Matcher matcher = URL_PATTERN.matcher(url);
        if (!matcher.find()) {
            throw new UnrecognizedDatabaseURLException(url, URL_PATTERN.pattern());
        }
        String portFromMatcher = matcher.group("port");
        String catalogFromMatcher = matcher.group("catalog");
        String nameFromMatcher = matcher.group("name");
        String fileNameFromMatcher = matcher.group("fileName");
        String hostnameFromMatcher = matcher.group("hostname");
        boolean setPort = null != portFromMatcher && !portFromMatcher.isEmpty();
        String name = null == nameFromMatcher ? fileNameFromMatcher : nameFromMatcher;
        this.hostname = null == hostnameFromMatcher ? "" : hostnameFromMatcher;
        this.port = setPort ? Integer.parseInt(portFromMatcher) : -1;
        this.catalog = null == catalogFromMatcher ? name : catalogFromMatcher;
        this.schema = null;
        String modelMemFromMatcher = matcher.group("modelMem");
        String modelSslOrTcpFromMatcher = matcher.group("modelSslOrTcp");
        String modelFileFromMatcher = matcher.group("modelFile");
        this.model = null == modelMemFromMatcher ? (null == modelSslOrTcpFromMatcher ? modelFileFromMatcher : modelSslOrTcpFromMatcher) : modelMemFromMatcher;
    }

    @Override
    public Properties getQueryProperties() {
        return new Properties();
    }

    @Override
    public Properties getDefaultQueryProperties() {
        return new Properties();
    }

    @Override
    public boolean isInSameDatabaseInstance(DataSourceMetaData dataSourceMetaData) {
        if (!(dataSourceMetaData instanceof H2DataSourceMetaData)) {
            return false;
        }
        if (!this.isSameModel(this.getModel(), ((H2DataSourceMetaData)dataSourceMetaData).getModel())) {
            return false;
        }
        return "".equals(this.hostname) && -1 == this.port ? Objects.equals(this.schema, dataSourceMetaData.getSchema()) : DataSourceMetaData.super.isInSameDatabaseInstance(dataSourceMetaData);
    }

    private boolean isSameModel(String model1, String model2) {
        if (MODEL_MEM.equalsIgnoreCase(model1)) {
            return model1.equalsIgnoreCase(model2) || MODEL_PWD.equalsIgnoreCase(model2) || MODEL_FILE.equalsIgnoreCase(model2);
        }
        if (MODEL_PWD.equalsIgnoreCase(model1)) {
            return model1.equalsIgnoreCase(model2) || MODEL_MEM.equalsIgnoreCase(model2) || MODEL_FILE.equalsIgnoreCase(model2);
        }
        if (MODEL_FILE.equalsIgnoreCase(model1)) {
            return model1.equalsIgnoreCase(model2) || MODEL_MEM.equalsIgnoreCase(model2) || MODEL_PWD.equalsIgnoreCase(model2);
        }
        return model1.equalsIgnoreCase(model2);
    }

    @Override
    @Generated
    public String getHostname() {
        return this.hostname;
    }

    @Generated
    public String getModel() {
        return this.model;
    }

    @Override
    @Generated
    public int getPort() {
        return this.port;
    }

    @Override
    @Generated
    public String getCatalog() {
        return this.catalog;
    }

    @Override
    @Generated
    public String getSchema() {
        return this.schema;
    }
}

