/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.statement.ddl;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.aware.CursorDefinitionAware;
import org.apache.shardingsphere.infra.binder.segment.table.TablesContext;
import org.apache.shardingsphere.infra.binder.statement.CommonSQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.ddl.CursorStatementContext;
import org.apache.shardingsphere.infra.binder.type.CursorAvailable;
import org.apache.shardingsphere.infra.binder.type.WhereAvailable;
import org.apache.shardingsphere.sql.parser.sql.common.extractor.TableExtractor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.cursor.CursorNameSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.MoveStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussCursorStatement;

public final class MoveStatementContext
extends CommonSQLStatementContext<MoveStatement>
implements CursorAvailable,
WhereAvailable,
CursorDefinitionAware {
    private CursorStatementContext cursorStatementContext;
    private TablesContext tablesContext = new TablesContext(Collections.emptyList(), this.getDatabaseType());

    public MoveStatementContext(MoveStatement sqlStatement) {
        super(sqlStatement);
    }

    @Override
    public Optional<CursorNameSegment> getCursorName() {
        return Optional.of(((MoveStatement)this.getSqlStatement()).getCursorName());
    }

    @Override
    public void setUpCursorDefinition(CursorStatementContext cursorStatementContext) {
        this.cursorStatementContext = cursorStatementContext;
        TableExtractor tableExtractor = new TableExtractor();
        tableExtractor.extractTablesFromSelect(((OpenGaussCursorStatement)cursorStatementContext.getSqlStatement()).getSelect());
        this.tablesContext = new TablesContext(tableExtractor.getRewriteTables(), this.getDatabaseType());
    }

    @Override
    public Collection<WhereSegment> getWhereSegments() {
        return null != this.cursorStatementContext ? this.cursorStatementContext.getWhereSegments() : Collections.emptyList();
    }

    @Override
    public Collection<ColumnSegment> getColumnSegments() {
        return null != this.cursorStatementContext ? this.cursorStatementContext.getColumnSegments() : Collections.emptyList();
    }

    @Generated
    public CursorStatementContext getCursorStatementContext() {
        return this.cursorStatementContext;
    }

    @Override
    @Generated
    public TablesContext getTablesContext() {
        return this.tablesContext;
    }
}

