/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.statement.dml;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.segment.select.groupby.GroupByContext;
import org.apache.shardingsphere.infra.binder.segment.select.groupby.engine.GroupByContextEngine;
import org.apache.shardingsphere.infra.binder.segment.select.orderby.OrderByContext;
import org.apache.shardingsphere.infra.binder.segment.select.orderby.OrderByItem;
import org.apache.shardingsphere.infra.binder.segment.select.orderby.engine.OrderByContextEngine;
import org.apache.shardingsphere.infra.binder.segment.select.pagination.PaginationContext;
import org.apache.shardingsphere.infra.binder.segment.select.pagination.engine.PaginationContextEngine;
import org.apache.shardingsphere.infra.binder.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.binder.segment.select.projection.ProjectionsContext;
import org.apache.shardingsphere.infra.binder.segment.select.projection.engine.ProjectionsContextEngine;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.AggregationDistinctProjection;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.AggregationProjection;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.ParameterMarkerProjection;
import org.apache.shardingsphere.infra.binder.segment.table.TablesContext;
import org.apache.shardingsphere.infra.binder.statement.CommonSQLStatementContext;
import org.apache.shardingsphere.infra.binder.type.TableAvailable;
import org.apache.shardingsphere.infra.binder.type.WhereAvailable;
import org.apache.shardingsphere.infra.exception.SchemaNotExistedException;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.schema.ShardingSphereSchema;
import org.apache.shardingsphere.sql.parser.sql.common.constant.ParameterMarkerType;
import org.apache.shardingsphere.sql.parser.sql.common.constant.SubqueryType;
import org.apache.shardingsphere.sql.parser.sql.common.extractor.TableExtractor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.subquery.SubquerySegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.ColumnOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.ExpressionOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.IndexOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.OrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.TextOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.JoinTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SubqueryTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.TableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.common.util.ExpressionExtractUtil;
import org.apache.shardingsphere.sql.parser.sql.common.util.SQLUtil;
import org.apache.shardingsphere.sql.parser.sql.common.util.SubqueryExtractUtil;
import org.apache.shardingsphere.sql.parser.sql.common.util.WhereExtractUtil;

public final class SelectStatementContext
extends CommonSQLStatementContext<SelectStatement>
implements TableAvailable,
WhereAvailable {
    private final TablesContext tablesContext;
    private final ProjectionsContext projectionsContext;
    private final GroupByContext groupByContext;
    private final OrderByContext orderByContext;
    private final PaginationContext paginationContext;
    private final Map<Integer, SelectStatementContext> subqueryContexts;
    private final Collection<WhereSegment> whereSegments = new LinkedList<WhereSegment>();
    private SubqueryType subqueryType;
    private boolean needAggregateRewrite;

    public SelectStatementContext(Map<String, ShardingSphereMetaData> metaDataMap, List<Object> parameters, SelectStatement sqlStatement, String defaultSchemaName) {
        super(sqlStatement);
        this.whereSegments.addAll(this.getWhereSegments(sqlStatement));
        this.subqueryContexts = this.createSubqueryContexts(metaDataMap, parameters, defaultSchemaName);
        this.tablesContext = new TablesContext(this.getAllTableSegments(), this.subqueryContexts);
        ShardingSphereSchema schema = this.getSchema(metaDataMap, defaultSchemaName);
        this.groupByContext = new GroupByContextEngine().createGroupByContext(sqlStatement);
        this.orderByContext = new OrderByContextEngine().createOrderBy(sqlStatement, this.groupByContext);
        this.projectionsContext = new ProjectionsContextEngine(schema, this.getDatabaseType()).createProjectionsContext(((SelectStatement)this.getSqlStatement()).getFrom(), ((SelectStatement)this.getSqlStatement()).getProjections(), this.groupByContext, this.orderByContext);
        this.paginationContext = new PaginationContextEngine().createPaginationContext(sqlStatement, this.projectionsContext, parameters, this.whereSegments);
    }

    private Map<Integer, SelectStatementContext> createSubqueryContexts(Map<String, ShardingSphereMetaData> metaDataMap, List<Object> parameters, String defaultSchemaName) {
        Collection subquerySegments = SubqueryExtractUtil.getSubquerySegments((SelectStatement)((SelectStatement)this.getSqlStatement()));
        HashMap<Integer, SelectStatementContext> result = new HashMap<Integer, SelectStatementContext>(subquerySegments.size(), 1.0f);
        for (SubquerySegment each : subquerySegments) {
            SelectStatementContext subqueryContext = new SelectStatementContext(metaDataMap, parameters, each.getSelect(), defaultSchemaName);
            subqueryContext.setSubqueryType(each.getSubqueryType());
            result.put(each.getStartIndex(), subqueryContext);
        }
        return result;
    }

    private ShardingSphereSchema getSchema(Map<String, ShardingSphereMetaData> metaDataMap, String defaultSchemaName) {
        String schemaName = this.tablesContext.getSchemaName().orElse(defaultSchemaName);
        ShardingSphereMetaData metaData = metaDataMap.get(schemaName);
        if (null == metaData) {
            throw new SchemaNotExistedException(schemaName);
        }
        return metaData.getSchema();
    }

    public boolean isContainsJoinQuery() {
        return ((SelectStatement)this.getSqlStatement()).getFrom() instanceof JoinTableSegment;
    }

    public boolean isContainsSubquery() {
        return !this.subqueryContexts.isEmpty();
    }

    public boolean isContainsHaving() {
        return ((SelectStatement)this.getSqlStatement()).getHaving().isPresent();
    }

    public boolean isContainsUnion() {
        return !((SelectStatement)this.getSqlStatement()).getUnionSegments().isEmpty();
    }

    public boolean isContainsDollarParameterMarker() {
        for (Projection projection : this.projectionsContext.getProjections()) {
            if (!(projection instanceof ParameterMarkerProjection) || ParameterMarkerType.DOLLAR != ((ParameterMarkerProjection)projection).getParameterMarkerType()) continue;
            return true;
        }
        for (ParameterMarkerExpressionSegment parameterMarkerExpressionSegment : this.getParameterMarkerExpressions()) {
            if (ParameterMarkerType.DOLLAR != parameterMarkerExpressionSegment.getParameterMarkerType()) continue;
            return true;
        }
        return false;
    }

    private Collection<ParameterMarkerExpressionSegment> getParameterMarkerExpressions() {
        LinkedList<ExpressionSegment> expressions = new LinkedList<ExpressionSegment>();
        for (WhereSegment each : this.whereSegments) {
            expressions.add(each.getExpr());
        }
        return ExpressionExtractUtil.getParameterMarkerExpressions(expressions);
    }

    public boolean isContainsPartialDistinctAggregation() {
        Collection aggregationProjections = this.projectionsContext.getProjections().stream().filter(each -> each instanceof AggregationProjection).collect(Collectors.toList());
        Collection<AggregationDistinctProjection> aggregationDistinctProjections = this.projectionsContext.getAggregationDistinctProjections();
        return aggregationProjections.size() > 1 && aggregationDistinctProjections.size() > 0 && aggregationProjections.size() != aggregationDistinctProjections.size();
    }

    public void setIndexes(Map<String, Integer> columnLabelIndexMap) {
        this.setIndexForAggregationProjection(columnLabelIndexMap);
        this.setIndexForOrderItem(columnLabelIndexMap, this.orderByContext.getItems());
        this.setIndexForOrderItem(columnLabelIndexMap, this.groupByContext.getItems());
    }

    private void setIndexForAggregationProjection(Map<String, Integer> columnLabelIndexMap) {
        for (AggregationProjection each : this.projectionsContext.getAggregationProjections()) {
            String columnLabel = SQLUtil.getExactlyValue((String)each.getColumnLabel());
            Preconditions.checkState((boolean)columnLabelIndexMap.containsKey(columnLabel), (String)"Can't find index: %s, please add alias for aggregate selections", (Object)each);
            each.setIndex(columnLabelIndexMap.get(columnLabel));
            for (AggregationProjection derived : each.getDerivedAggregationProjections()) {
                String derivedColumnLabel = SQLUtil.getExactlyValue((String)derived.getColumnLabel());
                Preconditions.checkState((boolean)columnLabelIndexMap.containsKey(derivedColumnLabel), (String)"Can't find index: %s", (Object)derived);
                derived.setIndex(columnLabelIndexMap.get(derivedColumnLabel));
            }
        }
    }

    private void setIndexForOrderItem(Map<String, Integer> columnLabelIndexMap, Collection<OrderByItem> orderByItems) {
        for (OrderByItem each : orderByItems) {
            Optional<Integer> itemIndex;
            if (each.getSegment() instanceof IndexOrderByItemSegment) {
                each.setIndex(((IndexOrderByItemSegment)each.getSegment()).getColumnIndex());
                continue;
            }
            if (each.getSegment() instanceof ColumnOrderByItemSegment && ((ColumnOrderByItemSegment)each.getSegment()).getColumn().getOwner().isPresent() && (itemIndex = this.projectionsContext.findProjectionIndex(((ColumnOrderByItemSegment)each.getSegment()).getText())).isPresent()) {
                each.setIndex(itemIndex.get());
                continue;
            }
            String columnLabel = this.getAlias(each.getSegment()).orElseGet(() -> this.getOrderItemText((TextOrderByItemSegment)each.getSegment()));
            Preconditions.checkState((boolean)columnLabelIndexMap.containsKey(columnLabel), (String)"Can't find index: %s", (Object)each);
            if (!columnLabelIndexMap.containsKey(columnLabel)) continue;
            each.setIndex(columnLabelIndexMap.get(columnLabel));
        }
    }

    private Optional<String> getAlias(OrderByItemSegment orderByItem) {
        if (this.projectionsContext.isUnqualifiedShorthandProjection()) {
            return Optional.empty();
        }
        String rawName = SQLUtil.getExactlyValue((String)((TextOrderByItemSegment)orderByItem).getText());
        for (Projection each : this.projectionsContext.getProjections()) {
            if (SQLUtil.getExactlyExpression((String)rawName).equalsIgnoreCase(SQLUtil.getExactlyExpression((String)SQLUtil.getExactlyValue((String)each.getExpression())))) {
                return each.getAlias();
            }
            if (rawName.equalsIgnoreCase(each.getAlias().orElse(null))) {
                return Optional.of(rawName);
            }
            if (!this.isSameColumnName(each, rawName)) continue;
            return each.getAlias();
        }
        return Optional.empty();
    }

    private boolean isSameColumnName(Projection projection, String name) {
        return projection instanceof ColumnProjection && name.equalsIgnoreCase(((ColumnProjection)projection).getName());
    }

    private String getOrderItemText(TextOrderByItemSegment orderByItemSegment) {
        if (orderByItemSegment instanceof ColumnOrderByItemSegment) {
            return SQLUtil.getExactlyValue((String)((ColumnOrderByItemSegment)orderByItemSegment).getColumn().getIdentifier().getValue());
        }
        return SQLUtil.getExactlyValue((String)((ExpressionOrderByItemSegment)orderByItemSegment).getExpression());
    }

    public boolean isSameGroupByAndOrderByItems() {
        return !this.groupByContext.getItems().isEmpty() && this.groupByContext.getItems().equals(this.orderByContext.getItems());
    }

    @Override
    public Collection<SimpleTableSegment> getAllTables() {
        return this.tablesContext.getTables();
    }

    @Override
    public Collection<WhereSegment> getWhereSegments() {
        return this.whereSegments;
    }

    private Collection<WhereSegment> getWhereSegments(SelectStatement selectStatement) {
        LinkedList<WhereSegment> result = new LinkedList<WhereSegment>();
        selectStatement.getWhere().ifPresent(result::add);
        result.addAll(WhereExtractUtil.getSubqueryWhereSegments((SelectStatement)selectStatement));
        result.addAll(WhereExtractUtil.getJoinWhereSegments((SelectStatement)selectStatement));
        return result;
    }

    private Collection<TableSegment> getAllTableSegments() {
        TableExtractor tableExtractor = new TableExtractor();
        tableExtractor.extractTablesFromSelect((SelectStatement)this.getSqlStatement());
        LinkedList<TableSegment> result = new LinkedList<TableSegment>(tableExtractor.getRewriteTables());
        for (TableSegment each : tableExtractor.getTableContext()) {
            if (!(each instanceof SubqueryTableSegment)) continue;
            result.add(each);
        }
        return result;
    }

    @Override
    @Generated
    public TablesContext getTablesContext() {
        return this.tablesContext;
    }

    @Generated
    public ProjectionsContext getProjectionsContext() {
        return this.projectionsContext;
    }

    @Generated
    public GroupByContext getGroupByContext() {
        return this.groupByContext;
    }

    @Generated
    public OrderByContext getOrderByContext() {
        return this.orderByContext;
    }

    @Generated
    public PaginationContext getPaginationContext() {
        return this.paginationContext;
    }

    @Generated
    public Map<Integer, SelectStatementContext> getSubqueryContexts() {
        return this.subqueryContexts;
    }

    @Generated
    public SubqueryType getSubqueryType() {
        return this.subqueryType;
    }

    @Generated
    public boolean isNeedAggregateRewrite() {
        return this.needAggregateRewrite;
    }

    @Generated
    public void setSubqueryType(SubqueryType subqueryType) {
        this.subqueryType = subqueryType;
    }

    @Generated
    public void setNeedAggregateRewrite(boolean needAggregateRewrite) {
        this.needAggregateRewrite = needAggregateRewrite;
    }
}

