/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.spi.job;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.spi.job.JobType;
import org.apache.shardingsphere.infra.util.spi.ShardingSphereServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JobTypeFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JobTypeFactory.class);
    private static final Map<String, JobType> CODE_JOB_TYPE_MAP = new ConcurrentHashMap<String, JobType>();

    public static JobType getInstance(String jobTypeCode) {
        JobType result = CODE_JOB_TYPE_MAP.get(jobTypeCode);
        Preconditions.checkNotNull((Object)result, (String)"Can not get job type by `%s`", (Object)jobTypeCode);
        return result;
    }

    static {
        ShardingSphereServiceLoader.register(JobType.class);
        for (JobType each : ShardingSphereServiceLoader.getServiceInstances(JobType.class)) {
            String typeCode = each.getTypeCode();
            JobType replaced = CODE_JOB_TYPE_MAP.put(typeCode, each);
            if (replaced == null) continue;
            log.error("Type code already exists, typeCode={}, replaced={}, current={}", new Object[]{typeCode, replaced, each, new Exception()});
        }
    }
}

