/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.api.datanode;

import java.util.Collection;
import lombok.Generated;
import org.apache.shardingsphere.infra.datanode.DataNode;

public final class JobDataNodeEntry {
    private final String logicTableName;
    private final Collection<DataNode> dataNodes;

    public String marshal() {
        StringBuilder result = new StringBuilder(this.getMarshalledTextEstimatedLength());
        result.append(this.logicTableName);
        result.append(":");
        for (DataNode each : this.dataNodes) {
            result.append(each.format()).append(',');
        }
        if (!this.dataNodes.isEmpty()) {
            result.setLength(result.length() - 1);
        }
        return result.toString();
    }

    public int getMarshalledTextEstimatedLength() {
        return this.logicTableName.length() + 1 + this.dataNodes.stream().mapToInt(DataNode::getFormattedTextLength).sum() + this.dataNodes.size();
    }

    @Generated
    public JobDataNodeEntry(String logicTableName, Collection<DataNode> dataNodes) {
        this.logicTableName = logicTableName;
        this.dataNodes = dataNodes;
    }
}

