/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.task;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import org.apache.servicecomb.serviceregistry.event.ExceptionEvent;
import org.apache.servicecomb.serviceregistry.task.AbstractRegisterTask;
import org.apache.servicecomb.serviceregistry.task.HeartbeatResult;
import org.apache.servicecomb.serviceregistry.task.MicroserviceInstanceHeartbeatTask;
import org.apache.servicecomb.serviceregistry.task.MicroserviceServiceCenterTask;
import org.apache.servicecomb.serviceregistry.task.ServiceCenterTaskMonitor;
import org.apache.servicecomb.serviceregistry.task.TaskStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceCenterTask
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceCenterTask.class);
    private EventBus eventBus;
    private int interval;
    private MicroserviceServiceCenterTask microserviceServiceCenterTask;
    private boolean registerInstanceSuccess = false;
    private ServiceCenterTaskMonitor serviceCenterTaskMonitor = new ServiceCenterTaskMonitor();

    public ServiceCenterTask(EventBus eventBus, int interval, MicroserviceServiceCenterTask microserviceServiceCenterTask) {
        this.eventBus = eventBus;
        this.interval = interval;
        this.microserviceServiceCenterTask = microserviceServiceCenterTask;
        this.eventBus.register((Object)this);
    }

    @Subscribe
    public void onRegisterTask(AbstractRegisterTask task) {
        LOGGER.info("read {} status is {}", (Object)task.getClass().getSimpleName(), (Object)task.taskStatus);
        if (task.getTaskStatus() == TaskStatus.FINISHED) {
            this.registerInstanceSuccess = true;
        } else {
            this.onException();
        }
    }

    @Subscribe
    public void onMicroserviceInstanceHeartbeatTask(MicroserviceInstanceHeartbeatTask task) {
        if (task.getHeartbeatResult() != HeartbeatResult.SUCCESS) {
            LOGGER.info("read MicroserviceInstanceHeartbeatTask status is {}", (Object)task.taskStatus);
            this.onException();
        }
    }

    @Subscribe
    public void onExceptionEvent(ExceptionEvent event) {
        LOGGER.info("read exception event, message is :{}", (Object)event.getThrowable().getMessage());
        this.onException();
    }

    private void onException() {
        if (this.registerInstanceSuccess) {
            this.registerInstanceSuccess = false;
        }
    }

    public void init() {
        this.microserviceServiceCenterTask.run();
    }

    @Override
    public void run() {
        try {
            this.serviceCenterTaskMonitor.beginCycle(this.interval);
            this.microserviceServiceCenterTask.run();
            this.serviceCenterTaskMonitor.endCycle();
        }
        catch (Throwable e) {
            LOGGER.error("unexpected exception caught from service center task. ", e);
        }
    }

    @VisibleForTesting
    public boolean isRegisterInstanceSuccess() {
        return this.registerInstanceSuccess;
    }
}

