/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.erasurecode.rawcoder;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.io.erasurecode.ECChunk;
import org.apache.hadoop.io.erasurecode.ErasureCoderOptions;
import org.apache.hadoop.io.erasurecode.rawcoder.ByteArrayDecodingState;
import org.apache.hadoop.io.erasurecode.rawcoder.ByteBufferDecodingState;
import org.apache.hadoop.io.erasurecode.rawcoder.CoderUtil;

@InterfaceAudience.Private
public abstract class RawErasureDecoder {
    private final ErasureCoderOptions coderOptions;

    public RawErasureDecoder(ErasureCoderOptions coderOptions) {
        this.coderOptions = coderOptions;
    }

    public void decode(ByteBuffer[] inputs, int[] erasedIndexes, ByteBuffer[] outputs) throws IOException {
        int i;
        ByteBufferDecodingState decodingState = new ByteBufferDecodingState(this, inputs, erasedIndexes, outputs);
        boolean usingDirectBuffer = decodingState.usingDirectBuffer;
        int dataLen = decodingState.decodeLength;
        if (dataLen == 0) {
            return;
        }
        int[] inputPositions = new int[inputs.length];
        for (i = 0; i < inputPositions.length; ++i) {
            if (inputs[i] == null) continue;
            inputPositions[i] = inputs[i].position();
        }
        if (usingDirectBuffer) {
            this.doDecode(decodingState);
        } else {
            ByteArrayDecodingState badState = decodingState.convertToByteArrayState();
            this.doDecode(badState);
        }
        for (i = 0; i < inputs.length; ++i) {
            if (inputs[i] == null) continue;
            inputs[i].position(inputPositions[i] + dataLen);
        }
    }

    protected abstract void doDecode(ByteBufferDecodingState var1) throws IOException;

    public void decode(byte[][] inputs, int[] erasedIndexes, byte[][] outputs) throws IOException {
        ByteArrayDecodingState decodingState = new ByteArrayDecodingState(this, inputs, erasedIndexes, outputs);
        if (decodingState.decodeLength == 0) {
            return;
        }
        this.doDecode(decodingState);
    }

    protected abstract void doDecode(ByteArrayDecodingState var1) throws IOException;

    public void decode(ECChunk[] inputs, int[] erasedIndexes, ECChunk[] outputs) throws IOException {
        ByteBuffer[] newInputs = CoderUtil.toBuffers(inputs);
        ByteBuffer[] newOutputs = CoderUtil.toBuffers(outputs);
        this.decode(newInputs, erasedIndexes, newOutputs);
    }

    public int getNumDataUnits() {
        return this.coderOptions.getNumDataUnits();
    }

    public int getNumParityUnits() {
        return this.coderOptions.getNumParityUnits();
    }

    protected int getNumAllUnits() {
        return this.coderOptions.getNumAllUnits();
    }

    public boolean preferDirectBuffer() {
        return false;
    }

    public boolean allowChangeInputs() {
        return this.coderOptions.allowChangeInputs();
    }

    public boolean allowVerboseDump() {
        return this.coderOptions.allowVerboseDump();
    }

    public void release() {
    }
}

