/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.datasource.plugin.cdc.mysql;

import com.google.common.collect.Sets;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.datasource.plugin.api.DataSourceChannel;
import org.apache.seatunnel.datasource.plugin.api.DataSourcePluginException;
import org.apache.seatunnel.datasource.plugin.api.model.TableField;
import org.apache.seatunnel.datasource.plugin.cdc.mysql.MysqlCDCOptionRule;

public class MysqlCDCDataSourceChannel
implements DataSourceChannel {
    public static final Set<String> MYSQL_SYSTEM_DATABASES = Sets.newHashSet((Object[])new String[]{"information_schema", "mysql", "performance_schema", "sys"});

    public boolean canAbleGetSchema() {
        return true;
    }

    public OptionRule getDataSourceOptions(@NonNull String pluginName) {
        if (pluginName == null) {
            throw new NullPointerException("pluginName is marked non-null but is null");
        }
        return MysqlCDCOptionRule.optionRule();
    }

    public OptionRule getDatasourceMetadataFieldsByDataSourceName(@NonNull String pluginName) {
        if (pluginName == null) {
            throw new NullPointerException("pluginName is marked non-null but is null");
        }
        return MysqlCDCOptionRule.metadataRule();
    }

    public List<String> getTables(String pluginName, Map<String, String> requestParams, String database, Map<String, String> options) {
        return this.getTableNames(requestParams, database, options);
    }

    public List<String> getDatabases(String pluginName, Map<String, String> requestParams) {
        try {
            return this.getDataBaseNames(requestParams);
        }
        catch (SQLException e) {
            throw new DataSourcePluginException("get databases failed", (Throwable)e);
        }
    }

    public boolean checkDataSourceConnectivity(String pluginName, Map<String, String> requestParams) {
        return this.checkJdbcConnectivity(requestParams);
    }

    public List<TableField> getTableFields(String pluginName, Map<String, String> requestParams, String database, String table) {
        return this.getTableFields(requestParams, database, table);
    }

    public Map<String, List<TableField>> getTableFields(String pluginName, Map<String, String> requestParams, String database, List<String> tables) {
        HashMap<String, List<TableField>> tableFields = new HashMap<String, List<TableField>>(tables.size());
        for (String table : tables) {
            tableFields.put(table, this.getTableFields(requestParams, database, table));
        }
        return tableFields;
    }

    /*
     * Exception decompiling
     */
    protected boolean checkJdbcConnectivity(Map<String, String> requestParams) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected Connection init(Map<String, String> requestParams) throws SQLException {
        if (null == requestParams.get(MysqlCDCOptionRule.BASE_URL.key())) {
            throw new DataSourcePluginException("Jdbc url is null");
        }
        String url = requestParams.get(MysqlCDCOptionRule.BASE_URL.key());
        Properties info = new Properties();
        info.put("autoDeserialize", "false");
        info.put("allowLoadLocalInfile", "false");
        info.put("allowLoadLocalInfileInPath", "");
        if (null != requestParams.get(MysqlCDCOptionRule.PASSWORD.key()) && null != requestParams.get(MysqlCDCOptionRule.USERNAME.key())) {
            info.put("user", requestParams.get(MysqlCDCOptionRule.USERNAME.key()));
            info.put("password", requestParams.get(MysqlCDCOptionRule.PASSWORD.key()));
        }
        return DriverManager.getConnection(url, info);
    }

    /*
     * Exception decompiling
     */
    protected List<String> getDataBaseNames(Map<String, String> requestParams) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    protected List<String> getTableNames(Map<String, String> requestParams, String dbName, Map<String, String> options) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected List<TableField> getTableFields(Map<String, String> requestParams, String dbName, String tableName) {
        ArrayList<TableField> tableFields = new ArrayList<TableField>();
        if (dbName == null) {
            throw new NullPointerException("\u5165\u53c2\u5185\u6570\u636e\u5e93\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (tableName == null) {
            throw new NullPointerException("\u5165\u53c2\u5185\u6570\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try (Connection connection = this.init(requestParams);){
            PreparedStatement stmt = connection.prepareStatement("SELECT * FROM information_schema.columns WHERE table_schema = ? AND table_name = ? ORDER BY ORDINAL_POSITION ASC");
            stmt.setString(1, dbName);
            stmt.setString(2, tableName);
            ResultSet resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                TableField tableField = new TableField();
                tableField.setPrimaryKey(Boolean.valueOf("PRI".equals(resultSet.getString("COLUMN_KEY"))));
                tableField.setName(resultSet.getString("COLUMN_NAME"));
                tableField.setType(resultSet.getString("DATA_TYPE").toUpperCase());
                tableField.setComment(resultSet.getString("COLUMN_COMMENT"));
                tableField.setNullable(Boolean.valueOf("YES".equals(resultSet.getString("IS_NULLABLE"))));
                tableFields.add(tableField);
            }
            if (resultSet != null) {
                resultSet.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            throw new DataSourcePluginException("get table fields failed", (Throwable)e);
        }
        return tableFields;
    }

    private String getPrimaryKey(DatabaseMetaData metaData, String dbName, String tableName) throws SQLException {
        ResultSet primaryKeysInfo = metaData.getPrimaryKeys(dbName, "%", tableName);
        if (primaryKeysInfo.next()) {
            return primaryKeysInfo.getString("COLUMN_NAME");
        }
        return null;
    }

    private boolean isNotSystemDatabase(String dbName) {
        return MYSQL_SYSTEM_DATABASES.stream().noneMatch(systemDatabase -> StringUtils.equalsIgnoreCase(systemDatabase, dbName));
    }

    private boolean convertToBoolean(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return value.equals("TRUE");
        }
        return false;
    }
}

