/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.slack.sink;

import java.io.IOException;
import java.util.StringJoiner;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.common.utils.ExceptionUtils;
import org.apache.seatunnel.connectors.seatunnel.common.sink.AbstractSinkWriter;
import org.apache.seatunnel.connectors.seatunnel.slack.client.SlackClient;
import org.apache.seatunnel.connectors.seatunnel.slack.exception.SlackConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.slack.exception.SlackConnectorException;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlackWriter
extends AbstractSinkWriter<SeaTunnelRow, Void> {
    private static final Logger log = LoggerFactory.getLogger(SlackWriter.class);
    private final String conversationId;
    private final SlackClient slackClient;
    private final SeaTunnelRowType seaTunnelRowType;
    private static final long POST_MSG_WAITING_TIME = 1500L;

    public SlackWriter(SeaTunnelRowType seaTunnelRowType, Config pluginConfig) {
        this.seaTunnelRowType = seaTunnelRowType;
        this.slackClient = new SlackClient(pluginConfig);
        this.conversationId = this.slackClient.findConversation();
    }

    public void write(SeaTunnelRow element) throws IOException {
        Object[] fields = element.getFields();
        StringJoiner stringJoiner = new StringJoiner(",", "", "\n");
        for (Object field : fields) {
            stringJoiner.add(String.valueOf(field));
        }
        String message = stringJoiner.toString();
        try {
            this.slackClient.publishMessage(this.conversationId, message);
            Thread.sleep(1500L);
        }
        catch (Exception e) {
            log.error("Write to Slack Fail.", (Object)ExceptionUtils.getMessage((Throwable)e));
            throw new SlackConnectorException((SeaTunnelErrorCode)SlackConnectorErrorCode.WRITE_TO_SLACK_CHANNEL_FAILED, e);
        }
    }

    public void close() throws IOException {
    }
}

