/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.source;

import com.google.auto.service.AutoService;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.seatunnel.api.common.PrepareFailException;
import org.apache.seatunnel.api.serialization.Serializer;
import org.apache.seatunnel.api.source.Boundedness;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.source.SourceReader;
import org.apache.seatunnel.api.source.SourceSplitEnumerator;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.constants.PluginType;
import org.apache.seatunnel.common.exception.CommonErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcSourceOptions;
import org.apache.seatunnel.connectors.seatunnel.jdbc.exception.JdbcConnectorException;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.JdbcInputFormat;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.connection.JdbcConnectionProvider;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.connection.SimpleJdbcConnectionProvider;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialect;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialectLoader;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialectTypeMapper;
import org.apache.seatunnel.connectors.seatunnel.jdbc.source.JdbcSourceReader;
import org.apache.seatunnel.connectors.seatunnel.jdbc.source.JdbcSourceSplit;
import org.apache.seatunnel.connectors.seatunnel.jdbc.source.JdbcSourceSplitEnumerator;
import org.apache.seatunnel.connectors.seatunnel.jdbc.source.PartitionParameter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.state.JdbcSourceState;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={SeaTunnelSource.class})
public class JdbcSource
implements SeaTunnelSource<SeaTunnelRow, JdbcSourceSplit, JdbcSourceState> {
    protected static final Logger LOG = LoggerFactory.getLogger(JdbcSource.class);
    private JdbcSourceOptions jdbcSourceOptions;
    private SeaTunnelRowType typeInfo;
    private JdbcDialect jdbcDialect;
    private JdbcInputFormat inputFormat;
    private PartitionParameter partitionParameter;
    private JdbcConnectionProvider jdbcConnectionProvider;
    private String query;

    public String getPluginName() {
        return "Jdbc";
    }

    public void prepare(Config pluginConfig) throws PrepareFailException {
        this.jdbcSourceOptions = new JdbcSourceOptions(pluginConfig);
        this.jdbcConnectionProvider = new SimpleJdbcConnectionProvider(this.jdbcSourceOptions.getJdbcConnectionOptions());
        this.query = this.jdbcSourceOptions.getQuery();
        this.jdbcDialect = JdbcDialectLoader.load(this.jdbcSourceOptions.getJdbcConnectionOptions().getUrl());
        try (Connection connection = this.jdbcConnectionProvider.getOrEstablishConnection();){
            this.typeInfo = this.initTableField(connection);
            this.partitionParameter = this.initPartitionParameterAndExtendSql(this.jdbcConnectionProvider.getOrEstablishConnection());
        }
        catch (Exception e) {
            throw new PrepareFailException("jdbc", PluginType.SOURCE, e.toString());
        }
        this.inputFormat = new JdbcInputFormat(this.jdbcConnectionProvider, this.jdbcDialect, this.typeInfo, this.query, this.jdbcSourceOptions.getFetchSize(), this.jdbcSourceOptions.getJdbcConnectionOptions().isAutoCommit());
    }

    public Boundedness getBoundedness() {
        return Boundedness.BOUNDED;
    }

    public SeaTunnelDataType<SeaTunnelRow> getProducedType() {
        return this.typeInfo;
    }

    public SourceReader<SeaTunnelRow, JdbcSourceSplit> createReader(SourceReader.Context readerContext) throws Exception {
        return new JdbcSourceReader(this.inputFormat, readerContext);
    }

    public Serializer<JdbcSourceSplit> getSplitSerializer() {
        return super.getSplitSerializer();
    }

    public SourceSplitEnumerator<JdbcSourceSplit, JdbcSourceState> createEnumerator(SourceSplitEnumerator.Context<JdbcSourceSplit> enumeratorContext) throws Exception {
        return new JdbcSourceSplitEnumerator(enumeratorContext, this.jdbcSourceOptions, this.partitionParameter);
    }

    public SourceSplitEnumerator<JdbcSourceSplit, JdbcSourceState> restoreEnumerator(SourceSplitEnumerator.Context<JdbcSourceSplit> enumeratorContext, JdbcSourceState checkpointState) throws Exception {
        return new JdbcSourceSplitEnumerator(enumeratorContext, this.jdbcSourceOptions, this.partitionParameter);
    }

    private SeaTunnelRowType initTableField(Connection conn) {
        JdbcDialectTypeMapper jdbcDialectTypeMapper = this.jdbcDialect.getJdbcDialectTypeMapper();
        ArrayList seaTunnelDataTypes = new ArrayList();
        ArrayList<String> fieldNames = new ArrayList<String>();
        try {
            ResultSetMetaData resultSetMetaData = this.jdbcDialect.getResultSetMetaData(conn, this.jdbcSourceOptions);
            for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                fieldNames.add(resultSetMetaData.getColumnName(i));
                seaTunnelDataTypes.add(jdbcDialectTypeMapper.mapping(resultSetMetaData, i));
            }
        }
        catch (Exception e) {
            LOG.warn("get row type info exception", (Throwable)e);
        }
        return new SeaTunnelRowType(fieldNames.toArray(new String[0]), seaTunnelDataTypes.toArray(new SeaTunnelDataType[0]));
    }

    private PartitionParameter initPartitionParameter(String columnName, Connection connection) throws SQLException {
        long max = Long.MAX_VALUE;
        long min = Long.MIN_VALUE;
        if (this.jdbcSourceOptions.getPartitionLowerBound().isPresent() && this.jdbcSourceOptions.getPartitionUpperBound().isPresent()) {
            max = this.jdbcSourceOptions.getPartitionUpperBound().get();
            min = this.jdbcSourceOptions.getPartitionLowerBound().get();
            return new PartitionParameter(columnName, min, max, this.jdbcSourceOptions.getPartitionNumber().orElse(null));
        }
        try (ResultSet rs = connection.createStatement().executeQuery(String.format("SELECT MAX(%s),MIN(%s) FROM (%s) tt", columnName, columnName, this.query));){
            if (rs.next()) {
                max = this.jdbcSourceOptions.getPartitionUpperBound().isPresent() ? this.jdbcSourceOptions.getPartitionUpperBound().get() : Long.parseLong(rs.getString(1));
                min = this.jdbcSourceOptions.getPartitionLowerBound().isPresent() ? this.jdbcSourceOptions.getPartitionLowerBound().get() : Long.parseLong(rs.getString(2));
            }
        }
        return new PartitionParameter(columnName, min, max, this.jdbcSourceOptions.getPartitionNumber().orElse(null));
    }

    private PartitionParameter initPartitionParameterAndExtendSql(Connection connection) throws SQLException {
        if (this.jdbcSourceOptions.getPartitionColumn().isPresent()) {
            String partitionColumn = this.jdbcSourceOptions.getPartitionColumn().get();
            HashMap<String, SeaTunnelDataType> fieldTypes = new HashMap<String, SeaTunnelDataType>();
            for (int i = 0; i < this.typeInfo.getFieldNames().length; ++i) {
                fieldTypes.put(this.typeInfo.getFieldName(i), this.typeInfo.getFieldType(i));
            }
            if (!fieldTypes.containsKey(partitionColumn)) {
                throw new JdbcConnectorException((SeaTunnelErrorCode)CommonErrorCode.ILLEGAL_ARGUMENT, String.format("field %s not contain in query %s", partitionColumn, this.query));
            }
            SeaTunnelDataType partitionColumnType = (SeaTunnelDataType)fieldTypes.get(partitionColumn);
            if (!this.isNumericType(partitionColumnType)) {
                throw new JdbcConnectorException((SeaTunnelErrorCode)CommonErrorCode.ILLEGAL_ARGUMENT, String.format("%s is not numeric type", partitionColumn));
            }
            PartitionParameter partitionParameter = this.initPartitionParameter(partitionColumn, connection);
            this.query = String.format("SELECT * FROM (%s) tt where " + partitionColumn + " >= ? AND " + partitionColumn + " <= ?", this.query);
            return partitionParameter;
        }
        LOG.info("The partition_column parameter is not configured, and the source parallelism is set to 1");
        return null;
    }

    private boolean isNumericType(SeaTunnelDataType<?> type) {
        return type.equals((Object)BasicType.INT_TYPE) || type.equals((Object)BasicType.LONG_TYPE);
    }
}

