/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.sink;

import com.google.auto.service.AutoService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.seatunnel.api.common.JobContext;
import org.apache.seatunnel.api.common.PrepareFailException;
import org.apache.seatunnel.api.serialization.DefaultSerializer;
import org.apache.seatunnel.api.serialization.Serializer;
import org.apache.seatunnel.api.sink.SeaTunnelSink;
import org.apache.seatunnel.api.sink.SinkAggregatedCommitter;
import org.apache.seatunnel.api.sink.SinkWriter;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcSinkOptions;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialect;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialectLoader;
import org.apache.seatunnel.connectors.seatunnel.jdbc.sink.JdbcExactlyOnceSinkWriter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.sink.JdbcSinkAggregatedCommitter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.sink.JdbcSinkWriter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.state.JdbcAggregatedCommitInfo;
import org.apache.seatunnel.connectors.seatunnel.jdbc.state.JdbcSinkState;
import org.apache.seatunnel.connectors.seatunnel.jdbc.state.XidInfo;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

@AutoService(value={SeaTunnelSink.class})
public class JdbcSink
implements SeaTunnelSink<SeaTunnelRow, JdbcSinkState, XidInfo, JdbcAggregatedCommitInfo> {
    private Config pluginConfig;
    private SeaTunnelRowType seaTunnelRowType;
    private JobContext jobContext;
    private JdbcSinkOptions jdbcSinkOptions;
    private JdbcDialect dialect;

    public String getPluginName() {
        return "Jdbc";
    }

    public void prepare(Config pluginConfig) throws PrepareFailException {
        this.pluginConfig = pluginConfig;
        this.jdbcSinkOptions = new JdbcSinkOptions(this.pluginConfig);
        this.dialect = JdbcDialectLoader.load(this.jdbcSinkOptions.getJdbcConnectionOptions().getUrl());
    }

    public SinkWriter<SeaTunnelRow, XidInfo, JdbcSinkState> createWriter(SinkWriter.Context context) throws IOException {
        Object sinkWriter = this.jdbcSinkOptions.isExactlyOnce() ? new JdbcExactlyOnceSinkWriter(context, this.jobContext, this.dialect, this.jdbcSinkOptions, this.seaTunnelRowType, new ArrayList<JdbcSinkState>()) : new JdbcSinkWriter(context, this.dialect, this.jdbcSinkOptions, this.seaTunnelRowType);
        return sinkWriter;
    }

    public SinkWriter<SeaTunnelRow, XidInfo, JdbcSinkState> restoreWriter(SinkWriter.Context context, List<JdbcSinkState> states) throws IOException {
        if (this.jdbcSinkOptions.isExactlyOnce()) {
            return new JdbcExactlyOnceSinkWriter(context, this.jobContext, this.dialect, this.jdbcSinkOptions, this.seaTunnelRowType, states);
        }
        return super.restoreWriter(context, states);
    }

    public Optional<SinkAggregatedCommitter<XidInfo, JdbcAggregatedCommitInfo>> createAggregatedCommitter() {
        if (this.jdbcSinkOptions.isExactlyOnce()) {
            return Optional.of(new JdbcSinkAggregatedCommitter(this.jdbcSinkOptions));
        }
        return Optional.empty();
    }

    public void setTypeInfo(SeaTunnelRowType seaTunnelRowType) {
        this.seaTunnelRowType = seaTunnelRowType;
    }

    public SeaTunnelDataType<SeaTunnelRow> getConsumedType() {
        return this.seaTunnelRowType;
    }

    public Optional<Serializer<JdbcAggregatedCommitInfo>> getAggregatedCommitInfoSerializer() {
        if (this.jdbcSinkOptions.isExactlyOnce()) {
            return Optional.of(new DefaultSerializer());
        }
        return Optional.empty();
    }

    public void setJobContext(JobContext jobContext) {
        this.jobContext = jobContext;
    }

    public Optional<Serializer<XidInfo>> getCommitInfoSerializer() {
        if (this.jdbcSinkOptions.isExactlyOnce()) {
            return Optional.of(new DefaultSerializer());
        }
        return Optional.empty();
    }
}

