/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.seatunnel.connectors.seatunnel.jdbc.config.JdbcSourceOptions;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.converter.JdbcRowConverter;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.dialect.JdbcDialectTypeMapper;

public interface JdbcDialect
extends Serializable {
    public String dialectName();

    public JdbcRowConverter getRowConverter();

    public JdbcDialectTypeMapper getJdbcDialectTypeMapper();

    default public String quoteIdentifier(String identifier) {
        return identifier;
    }

    default public String getInsertIntoStatement(String tableName, String[] fieldNames) {
        String columns = Arrays.stream(fieldNames).map(this::quoteIdentifier).collect(Collectors.joining(", "));
        String placeholders = Arrays.stream(fieldNames).map(fieldName -> "?").collect(Collectors.joining(", "));
        return String.format("INSERT INTO %s (%s) VALUES (%s)", this.quoteIdentifier(tableName), columns, placeholders);
    }

    default public String getUpdateStatement(String tableName, String[] fieldNames, String[] conditionFields) {
        String setClause = Arrays.stream(fieldNames).map(fieldName -> String.format("%s = ?", this.quoteIdentifier((String)fieldName))).collect(Collectors.joining(", "));
        String conditionClause = Arrays.stream(conditionFields).map(fieldName -> String.format("%s = ?", this.quoteIdentifier((String)fieldName))).collect(Collectors.joining(" AND "));
        return String.format("UPDATE %s SET %s WHERE %s", this.quoteIdentifier(tableName), setClause, conditionClause);
    }

    default public String getDeleteStatement(String tableName, String[] conditionFields) {
        String conditionClause = Arrays.stream(conditionFields).map(fieldName -> String.format("%s = ?", this.quoteIdentifier((String)fieldName))).collect(Collectors.joining(" AND "));
        return String.format("DELETE FROM %s WHERE %s", this.quoteIdentifier(tableName), conditionClause);
    }

    default public String getRowExistsStatement(String tableName, String[] conditionFields) {
        String fieldExpressions = Arrays.stream(conditionFields).map(field -> String.format("%s = ?", this.quoteIdentifier((String)field))).collect(Collectors.joining(" AND "));
        return String.format("SELECT 1 FROM %s WHERE %s", this.quoteIdentifier(tableName), fieldExpressions);
    }

    public Optional<String> getUpsertStatement(String var1, String[] var2, String[] var3);

    default public PreparedStatement creatPreparedStatement(Connection connection, String queryTemplate, int fetchSize) throws SQLException {
        PreparedStatement statement = connection.prepareStatement(queryTemplate, 1003, 1007);
        if (fetchSize == Integer.MIN_VALUE || fetchSize > 0) {
            statement.setFetchSize(fetchSize);
        }
        return statement;
    }

    default public ResultSetMetaData getResultSetMetaData(Connection conn, JdbcSourceOptions jdbcSourceOptions) throws SQLException {
        PreparedStatement ps = conn.prepareStatement(jdbcSourceOptions.getQuery());
        return ps.getMetaData();
    }
}

