/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.internal.connection;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import lombok.NonNull;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.jdbc.exception.JdbcConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.jdbc.exception.JdbcConnectorException;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.connection.JdbcConnectionProvider;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.options.JdbcConnectionOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleJdbcConnectionProvider
implements JdbcConnectionProvider,
Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleJdbcConnectionProvider.class);
    private static final long serialVersionUID = 1L;
    private final JdbcConnectionOptions jdbcOptions;
    private transient Driver loadedDriver;
    private transient Connection connection;

    public SimpleJdbcConnectionProvider(@NonNull JdbcConnectionOptions jdbcOptions) {
        if (jdbcOptions == null) {
            throw new NullPointerException("jdbcOptions is marked @NonNull but is null");
        }
        this.jdbcOptions = jdbcOptions;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public boolean isConnectionValid() throws SQLException {
        return this.connection != null && this.connection.isValid(this.jdbcOptions.getConnectionCheckTimeoutSeconds());
    }

    private static Driver loadDriver(String driverName) throws ClassNotFoundException {
        Preconditions.checkNotNull((Object)driverName);
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            Driver driver = drivers.nextElement();
            if (!driver.getClass().getName().equals(driverName)) continue;
            return driver;
        }
        Class<?> clazz = Class.forName(driverName, true, Thread.currentThread().getContextClassLoader());
        try {
            return (Driver)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new JdbcConnectorException(JdbcConnectorErrorCode.CREATE_DRIVER_FAILED, "Fail to create driver of class " + driverName, ex);
        }
    }

    private Driver getLoadedDriver() throws SQLException, ClassNotFoundException {
        if (this.loadedDriver == null) {
            this.loadedDriver = SimpleJdbcConnectionProvider.loadDriver(this.jdbcOptions.getDriverName());
        }
        return this.loadedDriver;
    }

    @Override
    public Connection getOrEstablishConnection() throws SQLException, ClassNotFoundException {
        if (this.connection != null) {
            return this.connection;
        }
        Driver driver = this.getLoadedDriver();
        Properties info = new Properties();
        if (this.jdbcOptions.getUsername().isPresent()) {
            info.setProperty("user", this.jdbcOptions.getUsername().get());
        }
        if (this.jdbcOptions.getPassword().isPresent()) {
            info.setProperty("password", this.jdbcOptions.getPassword().get());
        }
        this.connection = driver.connect(this.jdbcOptions.getUrl(), info);
        if (this.connection == null) {
            throw new JdbcConnectorException((SeaTunnelErrorCode)JdbcConnectorErrorCode.NO_SUITABLE_DRIVER, "No suitable driver found for " + this.jdbcOptions.getUrl());
        }
        this.connection.setAutoCommit(this.jdbcOptions.isAutoCommit());
        return this.connection;
    }

    @Override
    public void closeConnection() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                LOG.warn("JDBC connection close failed.", (Throwable)e);
            }
            finally {
                this.connection = null;
            }
        }
    }

    @Override
    public Connection reestablishConnection() throws SQLException, ClassNotFoundException {
        this.closeConnection();
        return this.getOrEstablishConnection();
    }

    static {
        DriverManager.getDrivers();
    }
}

