/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.config;

import java.io.Serializable;
import java.util.List;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.Options;
import org.apache.seatunnel.connectors.seatunnel.jdbc.internal.options.JdbcConnectionOptions;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

public class JdbcConfig
implements Serializable {
    private static final int DEFAULT_CONNECTION_CHECK_TIMEOUT_SEC = 30;
    private static final boolean DEFAULT_AUTO_COMMIT = true;
    public static final Option<String> URL = Options.key((String)"url").stringType().noDefaultValue().withDescription("url");
    public static final Option<String> DRIVER = Options.key((String)"driver").stringType().noDefaultValue().withDescription("driver");
    public static final Option<Integer> CONNECTION_CHECK_TIMEOUT_SEC = Options.key((String)"connection_check_timeout_sec").intType().defaultValue((Object)30).withDescription("connection check time second");
    public static final Option<Integer> MAX_RETRIES = Options.key((String)"max_retries").intType().noDefaultValue().withDescription("max_retired");
    public static final Option<String> USER = Options.key((String)"user").stringType().noDefaultValue().withDescription("user");
    public static final Option<String> PASSWORD = Options.key((String)"password").stringType().noDefaultValue().withDescription("password");
    public static final Option<String> QUERY = Options.key((String)"query").stringType().noDefaultValue().withDescription("query");
    public static final Option<Boolean> AUTO_COMMIT = Options.key((String)"auto_commit").booleanType().defaultValue((Object)true).withDescription("auto commit");
    public static final Option<Integer> BATCH_SIZE = Options.key((String)"batch_size").intType().noDefaultValue().withDescription("batch size");
    public static final Option<Integer> FETCH_SIZE = Options.key((String)"fetch_size").intType().defaultValue((Object)0).withDescription("For queries that return a large number of objects, you can configure the row fetch size used in the query to improve performance by reducing the number database hits required to satisfy the selection criteria. Zero means use jdbc default value.");
    public static final Option<Integer> BATCH_INTERVAL_MS = Options.key((String)"batch_interval_ms").intType().noDefaultValue().withDescription("batch interval milliSecond");
    public static final Option<String> IS_EXACTLY_ONCE = Options.key((String)"is_exactly_once").stringType().noDefaultValue().withDescription("exactly once");
    public static final Option<String> XA_DATA_SOURCE_CLASS_NAME = Options.key((String)"xa_data_source_class_name").stringType().noDefaultValue().withDescription("data source class name");
    public static final Option<String> MAX_COMMIT_ATTEMPTS = Options.key((String)"max_commit_attempts").stringType().noDefaultValue().withDescription("max commit attempts");
    public static final Option<String> TRANSACTION_TIMEOUT_SEC = Options.key((String)"transaction_timeout_sec").stringType().noDefaultValue().withDescription("transaction timeout (second)");
    public static final Option<String> TABLE = Options.key((String)"table").stringType().noDefaultValue().withDescription("table");
    public static final Option<List<String>> PRIMARY_KEYS = Options.key((String)"primary_keys").listType().noDefaultValue().withDescription("primary keys");
    public static final Option<Boolean> SUPPORT_UPSERT_BY_QUERY_PRIMARY_KEY_EXIST = Options.key((String)"support_upsert_by_query_primary_key_exist").booleanType().defaultValue((Object)false).withDescription("support upsert by query primary_key exist");
    public static final Option<String> PARTITION_COLUMN = Options.key((String)"partition_column").stringType().noDefaultValue().withDescription("partition column");
    public static final Option<String> PARTITION_UPPER_BOUND = Options.key((String)"partition_upper_bound").stringType().noDefaultValue().withDescription("partition upper bound");
    public static final Option<String> PARTITION_LOWER_BOUND = Options.key((String)"partition_lower_bound").stringType().noDefaultValue().withDescription("partition lower bound");
    public static final Option<String> PARTITION_NUM = Options.key((String)"partition_num").stringType().noDefaultValue().withDescription("partition num");

    public static JdbcConnectionOptions buildJdbcConnectionOptions(Config config) {
        JdbcConnectionOptions jdbcOptions = new JdbcConnectionOptions();
        jdbcOptions.url = config.getString(URL.key());
        jdbcOptions.driverName = config.getString(DRIVER.key());
        if (config.hasPath(USER.key())) {
            jdbcOptions.username = config.getString(USER.key());
        }
        if (config.hasPath(PASSWORD.key())) {
            jdbcOptions.password = config.getString(PASSWORD.key());
        }
        if (config.hasPath(AUTO_COMMIT.key())) {
            jdbcOptions.autoCommit = config.getBoolean(AUTO_COMMIT.key());
        }
        if (config.hasPath(MAX_RETRIES.key())) {
            jdbcOptions.maxRetries = config.getInt(MAX_RETRIES.key());
        }
        if (config.hasPath(CONNECTION_CHECK_TIMEOUT_SEC.key())) {
            jdbcOptions.connectionCheckTimeoutSeconds = config.getInt(CONNECTION_CHECK_TIMEOUT_SEC.key());
        }
        if (config.hasPath(BATCH_SIZE.key())) {
            jdbcOptions.batchSize = config.getInt(BATCH_SIZE.key());
        }
        if (config.hasPath(BATCH_INTERVAL_MS.key())) {
            jdbcOptions.batchIntervalMs = config.getInt(BATCH_INTERVAL_MS.key());
        }
        if (config.hasPath(IS_EXACTLY_ONCE.key()) && config.getBoolean(IS_EXACTLY_ONCE.key())) {
            jdbcOptions.xaDataSourceClassName = config.getString(XA_DATA_SOURCE_CLASS_NAME.key());
            if (config.hasPath(MAX_COMMIT_ATTEMPTS.key())) {
                jdbcOptions.maxCommitAttempts = config.getInt(MAX_COMMIT_ATTEMPTS.key());
            }
            if (config.hasPath(TRANSACTION_TIMEOUT_SEC.key())) {
                jdbcOptions.transactionTimeoutSec = config.getInt(TRANSACTION_TIMEOUT_SEC.key());
            }
        }
        return jdbcOptions;
    }
}

