/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.jdbc.catalog;

import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.table.catalog.Catalog;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.catalog.exception.CatalogException;
import org.apache.seatunnel.api.table.catalog.exception.DatabaseNotExistException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJdbcCatalog
implements Catalog {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractJdbcCatalog.class);
    protected final String catalogName;
    protected final String defaultDatabase;
    protected final String username;
    protected final String pwd;
    protected final String baseUrl;
    protected final String defaultUrl;

    public AbstractJdbcCatalog(String catalogName, String defaultDatabase, String username, String pwd, String baseUrl) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)username));
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)pwd));
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)baseUrl));
        baseUrl = baseUrl.trim();
        AbstractJdbcCatalog.validateJdbcUrlWithoutDatabase(baseUrl);
        this.catalogName = catalogName;
        this.defaultDatabase = defaultDatabase;
        this.username = username;
        this.pwd = pwd;
        this.baseUrl = baseUrl.endsWith("/") ? baseUrl : baseUrl + "/";
        this.defaultUrl = this.baseUrl + defaultDatabase;
    }

    public static void validateJdbcUrlWithoutDatabase(String url) {
        String[] parts = url.trim().split("\\/+");
        Preconditions.checkArgument((parts.length == 2 ? 1 : 0) != 0);
    }

    public AbstractJdbcCatalog(String catalogName, String username, String pwd, String defaultUrl) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)username));
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)pwd));
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)defaultUrl));
        defaultUrl = defaultUrl.trim();
        AbstractJdbcCatalog.validateJdbcUrlWithDatabase(defaultUrl);
        this.catalogName = catalogName;
        this.username = username;
        this.pwd = pwd;
        this.defaultUrl = defaultUrl;
        String[] strings = AbstractJdbcCatalog.splitDefaultUrl(defaultUrl);
        this.baseUrl = strings[0];
        this.defaultDatabase = strings[1];
    }

    public static void validateJdbcUrlWithDatabase(String url) {
        String[] parts = url.trim().split("\\/+");
        Preconditions.checkArgument((parts.length == 3 ? 1 : 0) != 0);
    }

    public static String[] splitDefaultUrl(String defaultUrl) {
        String[] res = new String[2];
        int index = defaultUrl.lastIndexOf("/") + 1;
        res[0] = defaultUrl.substring(0, index);
        res[1] = defaultUrl.substring(index, defaultUrl.length());
        return res;
    }

    public String getDefaultDatabase() {
        return this.defaultDatabase;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.pwd;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void open() throws CatalogException {
        try {
            Connection conn = DriverManager.getConnection(this.defaultUrl, this.username, this.pwd);
            Throwable throwable = null;
            if (conn != null) {
                if (throwable != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    conn.close();
                }
            }
        }
        catch (SQLException e) {
            throw new CatalogException(String.format("Failed connecting to %s via JDBC.", this.defaultUrl), (Throwable)e);
        }
        LOG.info("Catalog {} established connection to {}", (Object)this.catalogName, (Object)this.defaultUrl);
    }

    public void close() throws CatalogException {
        LOG.info("Catalog {} closing", (Object)this.catalogName);
    }

    protected Optional<TableSchema.PrimaryKey> getPrimaryKey(DatabaseMetaData metaData, String schema, String table) throws SQLException {
        ResultSet rs = metaData.getPrimaryKeys(null, schema, table);
        HashMap<Integer, String> keySeqColumnName = new HashMap<Integer, String>();
        String pkName = null;
        while (rs.next()) {
            String columnName = rs.getString("COLUMN_NAME");
            pkName = rs.getString("PK_NAME");
            int keySeq = rs.getInt("KEY_SEQ");
            keySeqColumnName.put(keySeq - 1, columnName);
        }
        List<String> pkFields = Arrays.asList(new String[keySeqColumnName.size()]);
        keySeqColumnName.forEach(pkFields::set);
        if (!pkFields.isEmpty()) {
            pkName = pkName == null ? "pk_" + String.join((CharSequence)"_", pkFields) : pkName;
            return Optional.of(TableSchema.PrimaryKey.of((String)pkName, pkFields));
        }
        return Optional.empty();
    }

    public boolean databaseExists(String databaseName) throws CatalogException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)databaseName));
        return this.listDatabases().contains(databaseName);
    }

    public boolean tableExists(TablePath tablePath) throws CatalogException {
        try {
            return this.databaseExists(tablePath.getDatabaseName()) && this.listTables(tablePath.getDatabaseName()).contains(tablePath.getTableName());
        }
        catch (DatabaseNotExistException e) {
            return false;
        }
    }
}

