/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.sink.util;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.common.utils.DateTimeUtils;
import org.apache.seatunnel.common.utils.DateUtils;
import org.apache.seatunnel.common.utils.JsonUtils;
import org.apache.seatunnel.common.utils.TimeUtils;
import org.apache.seatunnel.connectors.seatunnel.file.exception.FileConnectorException;
import org.apache.seatunnel.connectors.seatunnel.file.sink.config.FileSinkConfig;

public class ExcelGenerator {
    private final List<Integer> sinkColumnsIndexInRow;
    private final SeaTunnelRowType seaTunnelRowType;
    private final DateUtils.Formatter dateFormat;
    private final DateTimeUtils.Formatter dateTimeFormat;
    private final TimeUtils.Formatter timeFormat;
    private final String fieldDelimiter;
    private final Workbook wb;
    private final CellStyle wholeNumberCellStyle;
    private final CellStyle stringCellStyle;
    private final CellStyle dateCellStyle;
    private final CellStyle dateTimeCellStyle;
    private final CellStyle timeCellStyle;
    private final Sheet st;
    private int row = 0;

    public ExcelGenerator(List<Integer> sinkColumnsIndexInRow, SeaTunnelRowType seaTunnelRowType, FileSinkConfig fileSinkConfig) {
        this.sinkColumnsIndexInRow = sinkColumnsIndexInRow;
        this.seaTunnelRowType = seaTunnelRowType;
        this.wb = fileSinkConfig.getMaxRowsInMemory() > 0 ? new SXSSFWorkbook(fileSinkConfig.getMaxRowsInMemory()) : new SXSSFWorkbook();
        Optional<String> sheetName = Optional.ofNullable(fileSinkConfig.getSheetName());
        Random random = new Random();
        this.st = this.wb.createSheet(sheetName.orElseGet(() -> String.format("Sheet%d", random.nextInt())));
        Row row = this.st.createRow(this.row);
        for (Integer i : sinkColumnsIndexInRow) {
            String fieldName = seaTunnelRowType.getFieldName(i.intValue());
            row.createCell(i).setCellValue(fieldName);
        }
        this.dateFormat = fileSinkConfig.getDateFormat();
        this.dateTimeFormat = fileSinkConfig.getDatetimeFormat();
        this.timeFormat = fileSinkConfig.getTimeFormat();
        this.fieldDelimiter = fileSinkConfig.getFieldDelimiter();
        this.wholeNumberCellStyle = this.createStyle(this.wb, "General");
        this.stringCellStyle = this.createStyle(this.wb, "@");
        this.dateCellStyle = this.createStyle(this.wb, this.dateFormat.getValue());
        this.dateTimeCellStyle = this.createStyle(this.wb, this.dateTimeFormat.getValue());
        this.timeCellStyle = this.createStyle(this.wb, this.timeFormat.getValue());
        ++this.row;
    }

    public void writeData(SeaTunnelRow seaTunnelRow) {
        Row excelRow = this.st.createRow(this.row);
        SeaTunnelDataType[] fieldTypes = this.seaTunnelRowType.getFieldTypes();
        for (Integer i : this.sinkColumnsIndexInRow) {
            Cell cell = excelRow.createCell(i);
            Object value = seaTunnelRow.getField(i.intValue());
            this.setCellValue(fieldTypes[i], this.seaTunnelRowType.getFieldName(i.intValue()), value, cell);
        }
        ++this.row;
    }

    public void flushAndCloseExcel(OutputStream output) throws IOException {
        this.wb.write(output);
        this.wb.close();
    }

    private void setCellValue(SeaTunnelDataType<?> type, String fieldName, Object value, Cell cell) {
        if (value == null) {
            cell.setBlank();
        } else {
            switch (type.getSqlType()) {
                case STRING: {
                    cell.setCellValue((String)value);
                    cell.setCellStyle(this.stringCellStyle);
                    break;
                }
                case BOOLEAN: {
                    cell.setCellValue((Boolean)value);
                    cell.setCellStyle(this.wholeNumberCellStyle);
                    break;
                }
                case SMALLINT: {
                    cell.setCellValue(((Short)value).shortValue());
                    cell.setCellStyle(this.wholeNumberCellStyle);
                    break;
                }
                case TINYINT: {
                    cell.setCellValue(((Byte)value).byteValue());
                    cell.setCellStyle(this.wholeNumberCellStyle);
                    break;
                }
                case INT: {
                    cell.setCellValue(((Integer)value).intValue());
                    cell.setCellStyle(this.wholeNumberCellStyle);
                    break;
                }
                case BIGINT: {
                    cell.setCellValue(((Long)value).longValue());
                    cell.setCellStyle(this.wholeNumberCellStyle);
                    break;
                }
                case FLOAT: {
                    cell.setCellValue(((Float)value).floatValue());
                    cell.setCellStyle(this.wholeNumberCellStyle);
                    break;
                }
                case DOUBLE: {
                    cell.setCellValue((Double)value);
                    cell.setCellStyle(this.wholeNumberCellStyle);
                    break;
                }
                case DECIMAL: {
                    cell.setCellValue(Double.parseDouble(value.toString()));
                    cell.setCellStyle(this.wholeNumberCellStyle);
                    break;
                }
                case BYTES: {
                    ArrayList<String> arrayData = new ArrayList<String>();
                    for (int i = 0; i < Array.getLength(value); ++i) {
                        arrayData.add(String.valueOf(Array.get(value, i)));
                    }
                    cell.setCellValue(((Object)arrayData).toString());
                    cell.setCellStyle(this.stringCellStyle);
                    break;
                }
                case MAP: 
                case ARRAY: {
                    cell.setCellValue(JsonUtils.toJsonString((Object)value));
                    cell.setCellStyle(this.stringCellStyle);
                    break;
                }
                case ROW: {
                    Object[] fields = ((SeaTunnelRow)value).getFields();
                    CharSequence[] strings = new String[fields.length];
                    for (int i = 0; i < fields.length; ++i) {
                        strings[i] = this.convert(((SeaTunnelRowType)type).getFieldName(i), fields[i], ((SeaTunnelRowType)type).getFieldType(i));
                    }
                    cell.setCellValue(String.join((CharSequence)this.fieldDelimiter, strings));
                    cell.setCellStyle(this.stringCellStyle);
                    break;
                }
                case DATE: {
                    cell.setCellValue((LocalDate)value);
                    cell.setCellStyle(this.dateCellStyle);
                    break;
                }
                case TIMESTAMP: 
                case TIME: {
                    this.setTimestampColumn(value, cell);
                    break;
                }
                default: {
                    throw CommonError.unsupportedDataType((String)"Excel", (String)type.getSqlType().toString(), (String)fieldName);
                }
            }
        }
    }

    private String convert(String fieldName, Object field, SeaTunnelDataType<?> fieldType) {
        if (field == null) {
            return "";
        }
        switch (fieldType.getSqlType()) {
            case MAP: 
            case ARRAY: {
                return JsonUtils.toJsonString((Object)field);
            }
            case STRING: 
            case BOOLEAN: 
            case SMALLINT: 
            case TINYINT: 
            case INT: 
            case BIGINT: 
            case FLOAT: 
            case DOUBLE: 
            case DECIMAL: {
                return field.toString();
            }
            case DATE: {
                return DateUtils.toString((LocalDate)((LocalDate)field), (DateUtils.Formatter)this.dateFormat);
            }
            case TIME: {
                return TimeUtils.toString((LocalTime)((LocalTime)field), (TimeUtils.Formatter)this.timeFormat);
            }
            case TIMESTAMP: {
                return DateTimeUtils.toString((LocalDateTime)((LocalDateTime)field), (DateTimeUtils.Formatter)this.dateTimeFormat);
            }
            case NULL: {
                return "";
            }
            case BYTES: {
                return new String((byte[])field);
            }
            case ROW: {
                Object[] fields = ((SeaTunnelRow)field).getFields();
                CharSequence[] strings = new String[fields.length];
                for (int i = 0; i < fields.length; ++i) {
                    strings[i] = this.convert(((SeaTunnelRowType)fieldType).getFieldName(i), fields[i], ((SeaTunnelRowType)fieldType).getFieldType(i));
                }
                return String.join((CharSequence)this.fieldDelimiter, strings);
            }
        }
        throw CommonError.unsupportedDataType((String)"Excel", (String)fieldType.getSqlType().toString(), (String)fieldName);
    }

    private void setTimestampColumn(Object value, Cell cell) {
        if (value instanceof Timestamp) {
            cell.setCellValue((Timestamp)value);
            cell.setCellStyle(this.dateTimeCellStyle);
        } else if (value instanceof LocalDate) {
            cell.setCellValue((LocalDate)value);
            cell.setCellStyle(this.dateCellStyle);
        } else if (value instanceof LocalDateTime) {
            cell.setCellValue(Timestamp.valueOf((LocalDateTime)value));
            cell.setCellStyle(this.dateTimeCellStyle);
        } else if (value instanceof LocalTime) {
            cell.setCellValue(Timestamp.valueOf(((LocalTime)value).atDate(LocalDate.ofEpochDay(0L))));
            cell.setCellStyle(this.timeCellStyle);
        } else {
            throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_DATA_TYPE, "Time series type expected for field");
        }
    }

    private CellStyle createStyle(Workbook wb, String format) {
        CreationHelper creationHelper = wb.getCreationHelper();
        CellStyle cellStyle = wb.createCellStyle();
        cellStyle.setDataFormat(creationHelper.createDataFormat().getFormat(format));
        return cellStyle;
    }
}

