/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.format.text.splitor;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.seatunnel.common.utils.ExceptionUtils;
import org.apache.seatunnel.format.text.splitor.TextLineSplitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvLineSplitor
implements TextLineSplitor,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(CsvLineSplitor.class);
    private Map<Character, CSVFormat> splitorFormatMap = new HashMap<Character, CSVFormat>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] spliteLine(String line, String splitor) {
        Character splitChar = Character.valueOf(splitor.charAt(0));
        if (Objects.isNull(this.splitorFormatMap.get(splitChar))) {
            this.splitorFormatMap.put(splitChar, CSVFormat.DEFAULT.withDelimiter(splitChar.charValue()));
        }
        CSVFormat format = this.splitorFormatMap.get(splitChar);
        CSVParser parser = null;
        try {
            parser = CSVParser.parse(line, format);
            ArrayList<String> res = new ArrayList<String>();
            for (CSVRecord record : parser.getRecords()) {
                for (String value : record) {
                    res.add(value);
                }
            }
            String[] stringArray = res.toArray(new String[0]);
            return stringArray;
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getMessage((Throwable)e));
            String[] stringArray = new String[]{};
            return stringArray;
        }
        finally {
            if (Objects.nonNull(parser)) {
                try {
                    parser.close();
                }
                catch (IOException e) {
                    log.error(ExceptionUtils.getMessage((Throwable)e));
                }
            }
        }
    }
}

